/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages;

import java.io.Serializable;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.VirSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.AbstractSchemaModalPage;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class VirSchemaModalPage
extends AbstractSchemaModalPage<VirSchemaTO> {
    private static final long serialVersionUID = 5979623248182851337L;

    public VirSchemaModalPage(AttributableType kind) {
        super(kind);
    }

    @Override
    public void setSchemaModalPage(final PageReference pageRef, final ModalWindow window, VirSchemaTO schema, final boolean createFlag) {
        if (schema == null) {
            schema = new VirSchemaTO();
        }
        Form schemaForm = new Form("form");
        schemaForm.setModel((IModel)new CompoundPropertyModel((Object)schema));
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", this.getString("name"), (IModel<String>)new PropertyModel((Object)schema, "name"));
        name.addRequiredLabel();
        name.setEnabled(createFlag);
        AjaxCheckBoxPanel readonly = new AjaxCheckBoxPanel("readonly", this.getString("readonly"), (IModel<Boolean>)new PropertyModel((Object)schema, "readonly"));
        IndicatingAjaxButton submit = new IndicatingAjaxButton("apply", (IModel)new ResourceModel("submit")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                VirSchemaTO schemaTO = (VirSchemaTO)form.getDefaultModelObject();
                try {
                    if (createFlag) {
                        VirSchemaModalPage.this.schemaRestClient.createVirSchema(VirSchemaModalPage.this.kind, schemaTO);
                    } else {
                        VirSchemaModalPage.this.schemaRestClient.updateVirSchema(VirSchemaModalPage.this.kind, schemaTO);
                    }
                    if (pageRef.getPage() instanceof BasePage) {
                        ((BasePage)pageRef.getPage()).setModalResult(true);
                    }
                    window.close(target);
                }
                catch (SyncopeClientException e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                    VirSchemaModalPage.this.feedbackPanel.refresh(target);
                }
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                VirSchemaModalPage.this.feedbackPanel.refresh(target);
            }
        };
        IndicatingAjaxButton cancel = new IndicatingAjaxButton("cancel", (IModel)new ResourceModel("cancel")){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                window.close(target);
            }
        };
        cancel.setDefaultFormProcessing(false);
        String allowedRoles = createFlag ? this.xmlRolesReader.getEntitlement("Schema", "create") : this.xmlRolesReader.getEntitlement("Schema", "update");
        MetaDataRoleAuthorizationStrategy.authorize((Component)submit, (Action)ENABLE, (String)allowedRoles);
        schemaForm.add(new Component[]{name});
        schemaForm.add(new Component[]{readonly});
        schemaForm.add(new Component[]{submit});
        schemaForm.add(new Component[]{cancel});
        this.add(new Component[]{schemaForm});
    }
}

