/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.console.pages.AbstractBasePage;
import org.apache.syncope.console.pages.BulkActionModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.DataTablePanel;
import org.apache.syncope.console.rest.BaseRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.CheckGroupColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Fragment;

public class AjaxDataTablePanel<T, S>
extends DataTablePanel<T, S> {
    private static final long serialVersionUID = -7264400471578272966L;

    public AjaxDataTablePanel(String id, final List<IColumn<T, S>> columns, ISortableDataProvider<T, S> dataProvider, final int rowsPerPage, final Collection<ActionLink.ActionType> actions, final BaseRestClient bulkActionExecutor, final String itemIdField, final String pageId, final PageReference pageRef) {
        super(id);
        final ModalWindow bulkModalWin = new ModalWindow("bulkModal");
        bulkModalWin.setCssClassName("w_silver");
        bulkModalWin.setInitialHeight(600);
        bulkModalWin.setInitialWidth(900);
        bulkModalWin.setCookieName("bulk-modal");
        this.add(new Component[]{bulkModalWin});
        bulkModalWin.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487149L;

            public void onClose(AjaxRequestTarget target) {
                AbstractSearchResultPanel.EventDataWrapper data = new AbstractSearchResultPanel.EventDataWrapper();
                data.setTarget(target);
                data.setRows(rowsPerPage);
                AjaxDataTablePanel.this.send((IEventSink)pageRef.getPage(), Broadcast.BREADTH, data);
                AbstractBasePage page = (AbstractBasePage)pageRef.getPage();
                if (page.isModalResult()) {
                    page.setModalResult(false);
                    AjaxDataTablePanel.this.getSession().info((Serializable)((Object)AjaxDataTablePanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{page.getFeedbackPanel()});
                }
            }
        });
        Fragment fragment = new Fragment("tablePanel", "bulkAvailable", (MarkupContainer)this);
        this.add(new Component[]{fragment});
        Form bulkActionForm = new Form("groupForm");
        fragment.add(new Component[]{bulkActionForm});
        this.group = new CheckGroup("checkgroup", this.model);
        this.group.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        bulkActionForm.add(new Component[]{this.group});
        columns.add(0, (IColumn<T, S>)new CheckGroupColumn(this.group));
        this.dataTable = new AjaxFallbackDefaultDataTable("dataTable", columns, dataProvider, rowsPerPage);
        this.group.add(new Component[]{this.dataTable});
        fragment.add(new Component[]{new ClearIndicatingAjaxButton("bulkActionLink", bulkActionForm, pageRef){
            private static final long serialVersionUID = 382302811235019988L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                bulkModalWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690941L;

                    public Page createPage() {
                        return new BulkActionModalPage(bulkModalWin, (Collection)AjaxDataTablePanel.this.group.getModelObject(), columns, actions, bulkActionExecutor, itemIdField, pageId);
                    }
                });
                bulkModalWin.show(target);
            }
        }});
    }
}

