/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.NonI18nPalette;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AttrTemplatesPanel
extends Panel {
    private static final long serialVersionUID = 1016028222120619000L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final RoleTO roleTO;
    private final NonI18nPalette<String> rAttrTemplates;
    private final NonI18nPalette<String> rDerAttrTemplates;
    private final NonI18nPalette<String> rVirAttrTemplates;

    public AttrTemplatesPanel(String id, RoleTO roleTO) {
        super(id);
        this.roleTO = roleTO;
        this.rAttrTemplates = this.buildPalette(Type.rAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.ROLE, SchemaType.NORMAL));
        this.add(new Component[]{this.rAttrTemplates});
        this.rDerAttrTemplates = this.buildPalette(Type.rDerAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.ROLE, SchemaType.DERIVED));
        this.add(new Component[]{this.rDerAttrTemplates});
        this.rVirAttrTemplates = this.buildPalette(Type.rVirAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.ROLE, SchemaType.VIRTUAL));
        this.add(new Component[]{this.rVirAttrTemplates});
        this.add(new Component[]{this.buildPalette(Type.mAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.MEMBERSHIP, SchemaType.NORMAL))});
        this.add(new Component[]{this.buildPalette(Type.mDerAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.MEMBERSHIP, SchemaType.DERIVED))});
        this.add(new Component[]{this.buildPalette(Type.mVirAttrTemplates, this.schemaRestClient.getSchemaNames(AttributableType.MEMBERSHIP, SchemaType.VIRTUAL))});
    }

    private NonI18nPalette<String> buildPalette(final Type type, List<String> allSchemas) {
        if (allSchemas != null && !allSchemas.isEmpty()) {
            Collections.sort(allSchemas);
        }
        ListModel availableSchemas = new ListModel(allSchemas);
        return new NonI18nPalette<String>(type.name(), (IModel)new PropertyModel((Object)this.roleTO, type.name()), (IModel)availableSchemas, new SelectChoiceRenderer(), 8, false, true){
            private static final long serialVersionUID = 2295567122085510330L;

            protected Recorder<String> newRecorderComponent() {
                Recorder recorder = super.newRecorderComponent();
                switch (type) {
                    case rAttrTemplates: 
                    case rDerAttrTemplates: 
                    case rVirAttrTemplates: {
                        recorder.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                            private static final long serialVersionUID = -1107858522700306810L;

                            protected void onUpdate(AjaxRequestTarget target) {
                                this.send((IEventSink)this.getPage(), Broadcast.BREADTH, new RoleAttrTemplatesChange(type, target));
                            }
                        }});
                        break;
                    }
                }
                return recorder;
            }
        };
    }

    public Collection<String> getSelected(Type type) {
        Collection<String> selected;
        switch (type) {
            case rAttrTemplates: {
                selected = this.rAttrTemplates.getModelCollection();
                break;
            }
            case rDerAttrTemplates: {
                selected = this.rDerAttrTemplates.getModelCollection();
                break;
            }
            case rVirAttrTemplates: {
                selected = this.rVirAttrTemplates.getModelCollection();
                break;
            }
            default: {
                selected = Collections.emptyList();
            }
        }
        return selected;
    }

    public static class RoleAttrTemplatesChange {
        private final Type type;
        private final AjaxRequestTarget target;

        public RoleAttrTemplatesChange(Type type, AjaxRequestTarget target) {
            this.type = type;
            this.target = target;
        }

        public Type getType() {
            return this.type;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    public static enum Type {
        rAttrTemplates,
        rDerAttrTemplates,
        rVirAttrTemplates,
        mAttrTemplates,
        mDerAttrTemplates,
        mVirAttrTemplates;

    }
}

