/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.ConfTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.AttributeSchemaType;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.rest.ConfigurationRestClient;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDoubleFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.DateTimeFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class AttributesPanel
extends Panel {
    private static final long serialVersionUID = 552437609667518888L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConfigurationRestClient confRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final AbstractAttributableTO entityTO;
    private final Mode mode;
    private final AttrTemplatesPanel attrTemplates;
    private Map<String, SchemaTO> schemas = new LinkedHashMap<String, SchemaTO>();

    public <T extends AbstractAttributableTO> AttributesPanel(String id, T entityTO, Form form, Mode mode) {
        this(id, entityTO, form, mode, null);
    }

    public <T extends AbstractAttributableTO> AttributesPanel(String id, T entityTO, final Form form, final Mode mode, AttrTemplatesPanel attrTemplates) {
        super(id);
        this.entityTO = entityTO;
        this.mode = mode;
        this.attrTemplates = attrTemplates;
        this.setOutputMarkupId(true);
        this.setSchemas();
        this.setAttrs();
        this.add(new Component[]{new AltListView<AttributeTO>("schemas", (IModel)new PropertyModel(entityTO, "attrs")){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<AttributeTO> item) {
                AttributeTO attributeTO = (AttributeTO)item.getDefaultModelObject();
                WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer("jexlHelp");
                AjaxLink<Void> questionMarkJexlHelp = JexlHelpUtil.getAjaxLink(jexlHelp, "questionMarkJexlHelp");
                item.add(new Component[]{questionMarkJexlHelp});
                questionMarkJexlHelp.add(new Component[]{jexlHelp});
                if (mode != Mode.TEMPLATE) {
                    questionMarkJexlHelp.setVisible(false);
                }
                item.add(new Component[]{new Label("name", attributeTO.getSchema())});
                FieldPanel panel = AttributesPanel.this.getFieldPanel((SchemaTO)AttributesPanel.this.schemas.get(attributeTO.getSchema()), form, attributeTO);
                if (mode == Mode.TEMPLATE || !((SchemaTO)AttributesPanel.this.schemas.get(attributeTO.getSchema())).isMultivalue()) {
                    item.add(new Component[]{panel});
                } else {
                    item.add(new Component[]{new MultiFieldPanel("panel", new PropertyModel((Object)attributeTO, "values"), panel)});
                }
            }
        }});
    }

    private void setSchemas() {
        List<SchemaTO> schemaTOs;
        AttributeTO attrLayout = null;
        if (this.entityTO instanceof RoleTO) {
            HashSet<String> allowed;
            RoleTO roleTO = (RoleTO)this.entityTO;
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf(this.mode, AttributableType.ROLE));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.ROLE);
            if (this.attrTemplates == null) {
                allowed = new HashSet(roleTO.getRAttrTemplates());
            } else {
                allowed = new HashSet<String>(this.attrTemplates.getSelected(AttrTemplatesPanel.Type.rAttrTemplates));
                if (roleTO.isInheritTemplates() && roleTO.getParent() != 0L) {
                    allowed.addAll(this.roleRestClient.read(roleTO.getParent()).getRAttrTemplates());
                }
            }
            this.schemaRestClient.filter(schemaTOs, allowed, true);
        } else if (this.entityTO instanceof UserTO) {
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf(this.mode, AttributableType.USER));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.USER);
        } else if (this.entityTO instanceof MembershipTO) {
            attrLayout = this.confRestClient.readAttrLayout(AttrLayoutType.valueOf(this.mode, AttributableType.MEMBERSHIP));
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.MEMBERSHIP);
            HashSet<String> allowed = new HashSet<String>(this.roleRestClient.read(((MembershipTO)this.entityTO).getRoleId()).getMAttrTemplates());
            this.schemaRestClient.filter(schemaTOs, allowed, true);
        } else {
            this.schemas = new TreeMap<String, SchemaTO>();
            schemaTOs = this.schemaRestClient.getSchemas(AttributableType.CONFIGURATION);
            Iterator<SchemaTO> it = schemaTOs.iterator();
            while (it.hasNext()) {
                SchemaTO schemaTO = it.next();
                for (AttrLayoutType type : AttrLayoutType.values()) {
                    if (!type.getConfKey().equals(schemaTO.getName())) continue;
                    it.remove();
                }
            }
        }
        this.schemas.clear();
        if (attrLayout != null && this.mode != Mode.TEMPLATE && !(this.entityTO instanceof ConfTO)) {
            this.schemaRestClient.filter(schemaTOs, attrLayout.getValues(), true);
            final HashMap attrLayoutMap = new HashMap(attrLayout.getValues().size());
            for (int i = 0; i < attrLayout.getValues().size(); ++i) {
                attrLayoutMap.put(attrLayout.getValues().get(i), i);
            }
            Collections.sort(schemaTOs, new Comparator<SchemaTO>(){

                @Override
                public int compare(SchemaTO schema1, SchemaTO schema2) {
                    int value = 0;
                    if ((Integer)attrLayoutMap.get(schema1.getName()) > (Integer)attrLayoutMap.get(schema2.getName())) {
                        value = 1;
                    } else if ((Integer)attrLayoutMap.get(schema1.getName()) < (Integer)attrLayoutMap.get(schema2.getName())) {
                        value = -1;
                    }
                    return value;
                }
            });
        }
        for (SchemaTO schemaTO : schemaTOs) {
            this.schemas.put(schemaTO.getName(), schemaTO);
        }
    }

    private void setAttrs() {
        ArrayList<AttributeTO> entityData = new ArrayList<AttributeTO>();
        Map attrMap = this.entityTO.getAttrMap();
        for (SchemaTO schema : this.schemas.values()) {
            AttributeTO attributeTO = new AttributeTO();
            attributeTO.setSchema(schema.getName());
            if (attrMap.get(schema.getName()) == null || ((AttributeTO)attrMap.get(schema.getName())).getValues().isEmpty()) {
                attributeTO.getValues().add("");
                attributeTO.setReadonly(schema.isReadonly());
            } else {
                attributeTO.getValues().addAll(((AttributeTO)attrMap.get(schema.getName())).getValues());
            }
            entityData.add(attributeTO);
        }
        this.entityTO.getAttrs().clear();
        this.entityTO.getAttrs().addAll(entityData);
    }

    private FieldPanel getFieldPanel(final SchemaTO schemaTO, Form form, AttributeTO attributeTO) {
        FieldPanel panel;
        boolean required = this.mode == Mode.TEMPLATE ? false : schemaTO.getMandatoryCondition().equalsIgnoreCase("true");
        boolean readOnly = this.mode == Mode.TEMPLATE ? false : schemaTO.isReadonly();
        AttributeSchemaType type = this.mode == Mode.TEMPLATE ? AttributeSchemaType.String : schemaTO.getType();
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", schemaTO.getName(), (IModel<Boolean>)new Model());
                panel.setRequired(required);
                break;
            }
            case Date: {
                String dataPattern;
                String string = dataPattern = schemaTO.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : schemaTO.getConversionPattern();
                if (dataPattern.contains("H")) {
                    panel = new DateTimeFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(), dataPattern);
                    if (required) {
                        panel.addRequiredLabel();
                        ((DateTimeFieldPanel)panel).setFormValidator(form);
                    }
                    panel.setStyleSheet("ui-widget-content ui-corner-all");
                    break;
                }
                panel = new DateTextFieldPanel("panel", schemaTO.getName(), (IModel<Date>)new Model(), dataPattern);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", schemaTO.getName(), new Model());
                ((AjaxDropDownChoicePanel)panel).setChoices(this.getEnumeratedValues(schemaTO));
                if (StringUtils.isNotBlank((CharSequence)schemaTO.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        private final Map<String, String> valueMap;
                        {
                            this.valueMap = AttributesPanel.this.getEnumeratedKeyValues(schemaTO);
                        }

                        public String getDisplayValue(String value) {
                            return this.valueMap.get(value) == null ? value : this.valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new SpinnerFieldPanel<Object>("panel", schemaTO.getName(), (Class<Object>)Long.class, (IModel<Object>)new Model(), null, null);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxDoubleFieldPanel("panel", schemaTO.getName(), schemaTO.getConversionPattern(), (IModel<Double>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                panel = new BinaryFieldPanel("panel", schemaTO.getName(), (IModel<String>)new Model(), this.schemas.containsKey(schemaTO.getName()) ? this.schemas.get(schemaTO.getName()).getMimeType() : null);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", schemaTO.getName(), (IModel<String>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        panel.setNewModel(attributeTO.getValues());
        return panel;
    }

    private Map<String, String> getEnumeratedKeyValues(SchemaTO schemaTO) {
        HashMap<String, String> res = new HashMap<String, String>();
        String[] values = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationValues()) ? new String[]{} : schemaTO.getEnumerationValues().split(";");
        String[] keys = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationKeys()) ? new String[]{} : schemaTO.getEnumerationKeys().split(";");
        for (int i = 0; i < values.length; ++i) {
            res.put(values[i].trim(), keys.length > i ? keys[i].trim() : null);
        }
        return res;
    }

    private List<String> getEnumeratedValues(SchemaTO schemaTO) {
        String[] values;
        ArrayList<String> res = new ArrayList<String>();
        for (String value : values = StringUtils.isBlank((CharSequence)schemaTO.getEnumerationValues()) ? new String[]{} : schemaTO.getEnumerationValues().split(";")) {
            res.add(value.trim());
        }
        return res;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AttrTemplatesPanel.RoleAttrTemplatesChange) {
            AttrTemplatesPanel.RoleAttrTemplatesChange update = (AttrTemplatesPanel.RoleAttrTemplatesChange)event.getPayload();
            if (this.attrTemplates != null && update.getType() == AttrTemplatesPanel.Type.rAttrTemplates) {
                this.setSchemas();
                this.setAttrs();
                update.getTarget().add(new Component[]{this});
            }
        }
    }
}

