/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class DerivedAttributesPanel
extends Panel {
    private static final long serialVersionUID = -5387344116983102292L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final AttrTemplatesPanel attrTemplates;

    public <T extends AbstractAttributableTO> DerivedAttributesPanel(String id, T entityTO) {
        this(id, entityTO, null);
    }

    public <T extends AbstractAttributableTO> DerivedAttributesPanel(String id, final T entityTO, final AttrTemplatesPanel attrTemplates) {
        super(id);
        this.attrTemplates = attrTemplates;
        this.setOutputMarkupId(true);
        LoadableDetachableModel<List<String>> derSchemas = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                List derSchemaNames;
                if (entityTO instanceof RoleTO) {
                    RoleTO roleTO = (RoleTO)entityTO;
                    if (attrTemplates == null) {
                        derSchemaNames = roleTO.getRDerAttrTemplates();
                    } else {
                        derSchemaNames = new ArrayList<String>(attrTemplates.getSelected(AttrTemplatesPanel.Type.rDerAttrTemplates));
                        if (roleTO.isInheritTemplates() && roleTO.getParent() != 0L) {
                            derSchemaNames.addAll(DerivedAttributesPanel.this.roleRestClient.read(roleTO.getParent()).getRDerAttrTemplates());
                        }
                    }
                } else {
                    derSchemaNames = entityTO instanceof UserTO ? DerivedAttributesPanel.this.schemaRestClient.getDerSchemaNames(AttributableType.USER) : DerivedAttributesPanel.this.roleRestClient.read(((MembershipTO)entityTO).getRoleId()).getMDerAttrTemplates();
                }
                return derSchemaNames;
            }
        };
        final WebMarkupContainer attributesContainer = new WebMarkupContainer("derAttrContainer");
        attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{attributesContainer});
        IndicatingAjaxButton addAttributeBtn = new IndicatingAjaxButton("addAttributeBtn", (IModel)new ResourceModel("addAttributeBtn")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                entityTO.getDerAttrs().add(new AttributeTO());
                target.add(new Component[]{attributesContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{attributesContainer});
            }
        };
        this.add(new Component[]{addAttributeBtn.setDefaultFormProcessing(false)});
        ListView<AttributeTO> attributes = new ListView<AttributeTO>("attrs", (IModel)new PropertyModel(entityTO, "derAttrs"), (IModel)derSchemas){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ IModel val$derSchemas;
            {
                this.val$derSchemas = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem<AttributeTO> item) {
                final AttributeTO attributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){
                    private static final long serialVersionUID = 7170946748485726506L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        entityTO.getDerAttrs().remove(attributeTO);
                        target.add(new Component[]{attributesContainer});
                    }

                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        super.updateAjaxAttributes(attributes);
                        AjaxCallListener ajaxCallListener = new AjaxCallListener(){
                            private static final long serialVersionUID = 7160235486520935153L;

                            public CharSequence getPrecondition(Component component) {
                                return "if (!confirm('" + this.getString("confirmDelete") + "')) return false;";
                            }
                        };
                        attributes.getAjaxCallListeners().add(ajaxCallListener);
                    }
                }});
                final DropDownChoice schemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)attributeTO, "schema"), this.val$derSchemas);
                schemaChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        attributeTO.setSchema((String)schemaChoice.getModelObject());
                    }
                }});
                schemaChoice.setRequired(true);
                schemaChoice.setOutputMarkupId(true);
                schemaChoice.setRequired(true);
                item.add(new Component[]{schemaChoice});
                List values = attributeTO.getValues();
                if (values == null || values.isEmpty()) {
                    item.add(new Component[]{new TextField("value", (IModel)new Model(null)).setVisible(false)});
                } else {
                    item.add(new Component[]{new TextField("value", (IModel)new Model((Serializable)values.get(0))).setEnabled(false)});
                }
            }
        };
        attributesContainer.add(new Component[]{attributes});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AttrTemplatesPanel.RoleAttrTemplatesChange) {
            AttrTemplatesPanel.RoleAttrTemplatesChange update = (AttrTemplatesPanel.RoleAttrTemplatesChange)event.getPayload();
            if (this.attrTemplates != null && update.getType() == AttrTemplatesPanel.Type.rDerAttrTemplates) {
                update.getTarget().add(new Component[]{this});
            }
        }
    }
}

