/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.pages.panels.SelectedEventsPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EventSelectionPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(EventSelectionPanel.class);
    private static final long serialVersionUID = 752233163798301002L;
    private final Set<String> selected = new HashSet<String>();

    public EventSelectionPanel(String id, final EventCategoryTO eventCategoryTO, IModel<List<String>> model) {
        super(id);
        this.setOutputMarkupId(true);
        List<String> events = this.getEvents(eventCategoryTO);
        this.selected.addAll((Collection)model.getObject());
        final CheckGroup successGroup = new CheckGroup("successGroup", this.selected);
        successGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<String> toBeRemoved = new HashSet<String>();
                HashSet<String> toBeAdded = new HashSet<String>();
                for (String event : EventSelectionPanel.this.getEvents(eventCategoryTO)) {
                    String eventString = LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.SUCCESS);
                    if (((Collection)successGroup.getModelObject()).contains(eventString)) {
                        toBeAdded.add(eventString);
                        continue;
                    }
                    toBeRemoved.add(eventString);
                }
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        successGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{successGroup});
        this.add(new Component[]{new Label("successLabel", (IModel)new ResourceModel("Success", "Success"))}).setVisible(!events.isEmpty());
        CheckGroupSelector successSelector = new CheckGroupSelector("successSelector", successGroup);
        successSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{successSelector});
        AltListView<String> categoryView = new AltListView<String>("categoryView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                String subcategory = (String)item.getModelObject();
                item.add(new Component[]{new Label("subcategory", (IModel)new ResourceModel(subcategory, subcategory))});
            }
        };
        this.add(new Component[]{categoryView});
        AltListView<String> successView = new AltListView<String>("successView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                String event = (String)item.getModelObject();
                Check successCheck = new Check("successCheck", (IModel)new Model((Serializable)((Object)LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.SUCCESS))), successGroup);
                item.add(new Component[]{successCheck});
            }
        };
        successGroup.add(new Component[]{successView});
        final CheckGroup failureGroup = new CheckGroup("failureGroup", this.selected);
        failureGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
                HashSet<String> toBeRemoved = new HashSet<String>();
                HashSet<String> toBeAdded = new HashSet<String>();
                for (String event : EventSelectionPanel.this.getEvents(eventCategoryTO)) {
                    String eventString = LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.FAILURE);
                    if (((Collection)failureGroup.getModelObject()).contains(eventString)) {
                        toBeAdded.add(eventString);
                        continue;
                    }
                    toBeRemoved.add(eventString);
                }
                EventSelectionPanel.this.send((IEventSink)EventSelectionPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, toBeAdded, toBeRemoved));
            }
        }});
        failureGroup.setVisible(!events.isEmpty());
        this.add(new Component[]{failureGroup});
        this.add(new Component[]{new Label("failureLabel", (IModel)new ResourceModel("Failure", "Failure"))}).setVisible(!events.isEmpty());
        CheckGroupSelector failureSelector = new CheckGroupSelector("failureSelector", failureGroup);
        failureSelector.setVisible(!events.isEmpty());
        this.add(new Component[]{failureSelector});
        AltListView<String> failureView = new AltListView<String>("failureView", events){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<String> item) {
                String event = (String)item.getModelObject();
                Check failureCheck = new Check("failureCheck", (IModel)new Model((Serializable)((Object)LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)eventCategoryTO.getType(), (String)eventCategoryTO.getCategory(), (String)eventCategoryTO.getSubcategory(), (String)event, (AuditElements.Result)AuditElements.Result.FAILURE))), failureGroup);
                item.add(new Component[]{failureCheck});
            }
        };
        failureGroup.add(new Component[]{failureView});
    }

    private List<String> getEvents(EventCategoryTO eventCategoryTO) {
        List res = eventCategoryTO.getEvents();
        if (res.isEmpty()) {
            if ((AuditElements.EventCategoryType.PROPAGATION == eventCategoryTO.getType() || AuditElements.EventCategoryType.SYNCHRONIZATION == eventCategoryTO.getType() || AuditElements.EventCategoryType.PUSH == eventCategoryTO.getType()) && StringUtils.isEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getType().toString());
            } else if (AuditElements.EventCategoryType.TASK == eventCategoryTO.getType() && StringUtils.isNotEmpty((CharSequence)eventCategoryTO.getCategory())) {
                res.add(eventCategoryTO.getCategory());
            }
        } else {
            Collections.sort(res);
        }
        return res;
    }

    protected abstract void onEventAction(IEvent<?> var1);

    public void onEvent(IEvent<?> event) {
        this.onEventAction(event);
    }
}

