/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.rest.ConfigurationRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutsPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutsPanel.class);
    private static final long serialVersionUID = -6804066913177804275L;
    private static final String CANCEL = "cancel";
    private static final String APPLY = "apply";
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConfigurationRestClient confRestClient;

    public LayoutsPanel(String id, AttrLayoutType attrLayoutType, final NotificationPanel feedbackPanel) {
        super(id);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        Form form = new Form("form");
        form.setOutputMarkupId(true);
        final AttributeTO attrLayout = this.confRestClient.readAttrLayout(attrLayoutType);
        form.setModel((IModel)new CompoundPropertyModel((Object)attrLayout.getValues()));
        List fields = this.schemaRestClient.getSchemaNames(attrLayoutType.getAttrType());
        ListModel selectedFields = new ListModel(attrLayout.getValues().isEmpty() ? fields : attrLayout.getValues());
        ListModel availableFields = new ListModel(fields);
        form.add(new Component[]{new AjaxPalettePanel("fields", selectedFields, availableFields, new SelectChoiceRenderer(), true, true)});
        IndicatingAjaxButton submit = new IndicatingAjaxButton(APPLY, (IModel)new ResourceModel(APPLY)){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                try {
                    LayoutsPanel.this.confRestClient.set(attrLayout);
                    this.info((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While saving layout configuration", (Throwable)e);
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                }
                feedbackPanel.refresh(target);
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                this.error((Serializable)((Object)(this.getString("error") + ": While saving layout configuration")));
                feedbackPanel.refresh(target);
            }
        };
        form.add(new Component[]{submit});
        IndicatingAjaxButton cancel = new IndicatingAjaxButton(CANCEL, (IModel)new ResourceModel(CANCEL)){
            private static final long serialVersionUID = -958724007591692537L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{container});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
        cancel.setDefaultFormProcessing(false);
        form.add(new Component[]{cancel});
        container.add(new Component[]{form});
        this.add(new Component[]{container});
    }
}

