/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.to.EventCategoryTO;
import org.apache.syncope.common.types.AuditElements;
import org.apache.syncope.common.util.LoggerEventUtils;
import org.apache.syncope.console.pages.panels.EventSelectionPanel;
import org.apache.syncope.console.pages.panels.SelectedEventsPanel;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggerCategoryPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(LoggerCategoryPanel.class);
    private static final long serialVersionUID = 6429053774964787734L;
    private final List<EventCategoryTO> eventCategoryTOs;
    private final EventCategoryTO eventCategoryTO = new EventCategoryTO();
    private final WebMarkupContainer categoryContainer;
    private final WebMarkupContainer eventsContainer;
    private final SelectedEventsPanel selectedEventsPanel;
    private final AjaxDropDownChoicePanel<AuditElements.EventCategoryType> type;
    private final AjaxDropDownChoicePanel<String> category;
    private final AjaxDropDownChoicePanel<String> subcategory;
    private final AjaxTextFieldPanel custom;
    private final ActionLinksPanel actionPanel;
    private final IModel<List<String>> model;

    public LoggerCategoryPanel(String id, List<EventCategoryTO> eventCategoryTOs, IModel<List<String>> model, PageReference pageReference, String pageId) {
        super(id);
        this.model = model;
        this.selectedEventsPanel = new SelectedEventsPanel("selectedEventsPanel", model);
        this.add(new Component[]{this.selectedEventsPanel});
        this.eventCategoryTOs = eventCategoryTOs;
        this.categoryContainer = new WebMarkupContainer("categoryContainer");
        this.categoryContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.categoryContainer});
        this.eventsContainer = new WebMarkupContainer("eventsContainer");
        this.eventsContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.eventsContainer});
        this.authorizeList();
        this.authorizeChanges();
        this.categoryContainer.add(new Component[]{new Label("typeLabel", (IModel)new ResourceModel("type", "type"))});
        this.type = new AjaxDropDownChoicePanel("type", "type", new PropertyModel((Object)this.eventCategoryTO, "type"), false);
        this.type.setChoices(Arrays.asList(AuditElements.EventCategoryType.values()));
        this.type.setStyleSheet("ui-widget-content ui-corner-all");
        this.type.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<AuditElements.EventCategoryType>(){
            private static final long serialVersionUID = 2317134950949778735L;

            public String getDisplayValue(AuditElements.EventCategoryType eventCategoryType) {
                return eventCategoryType.name();
            }

            public String getIdValue(AuditElements.EventCategoryType eventCategoryType, int i) {
                return eventCategoryType.name();
            }
        });
        this.categoryContainer.add(new Component[]{this.type});
        this.type.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                LoggerCategoryPanel.this.send((IEventSink)LoggerCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, LoggerCategoryPanel.this.type));
            }
        }});
        this.categoryContainer.add(new Component[]{new Label("categoryLabel", (IModel)new ResourceModel("category", "category"))});
        this.category = new AjaxDropDownChoicePanel("category", "category", new PropertyModel((Object)this.eventCategoryTO, "category"), false);
        this.category.setChoices(this.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
        this.category.setStyleSheet("ui-widget-content ui-corner-all");
        this.categoryContainer.add(new Component[]{this.category});
        this.category.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306811L;

            protected void onUpdate(AjaxRequestTarget target) {
                LoggerCategoryPanel.this.send((IEventSink)LoggerCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, LoggerCategoryPanel.this.category));
            }
        }});
        this.categoryContainer.add(new Component[]{new Label("subcategoryLabel", (IModel)new ResourceModel("subcategory", "subcategory"))});
        this.subcategory = new AjaxDropDownChoicePanel("subcategory", "subcategory", new PropertyModel((Object)this.eventCategoryTO, "subcategory"), false);
        this.subcategory.setChoices(this.filter(eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
        this.subcategory.setStyleSheet("ui-widget-content ui-corner-all");
        this.categoryContainer.add(new Component[]{this.subcategory});
        this.subcategory.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306812L;

            protected void onUpdate(AjaxRequestTarget target) {
                LoggerCategoryPanel.this.send((IEventSink)LoggerCategoryPanel.this, Broadcast.EXACT, new ChangeCategoryEvent(target, LoggerCategoryPanel.this.subcategory));
            }
        }});
        this.categoryContainer.add(new Component[]{new Label("customLabel", (IModel)new ResourceModel("custom", "custom")).setVisible(false)});
        this.custom = new AjaxTextFieldPanel("custom", "custom", (IModel<String>)new Model(null));
        this.custom.setStyleSheet("ui-widget-content ui-corner-all short_fixedsize");
        this.custom.setVisible(false);
        this.custom.setEnabled(false);
        this.categoryContainer.add(new Component[]{this.custom});
        this.actionPanel = new ActionLinksPanel("customActions", (IModel<?>)new Model(), pageReference);
        this.categoryContainer.add(new Component[]{this.actionPanel});
        this.actionPanel.add(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)LoggerCategoryPanel.this.custom.getModelObject()))) {
                    Map.Entry parsed = LoggerEventUtils.parseEventCategory((String)((String)LoggerCategoryPanel.this.custom.getModelObject()));
                    String eventString = LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)((EventCategoryTO)parsed.getKey()).getType(), null, null, (String)(((EventCategoryTO)parsed.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategoryTO)parsed.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)parsed.getValue()));
                    LoggerCategoryPanel.this.custom.setModelObject("");
                    LoggerCategoryPanel.this.send((IEventSink)LoggerCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Collections.singleton(eventString), Collections.<String>emptySet()));
                    target.add(new Component[]{LoggerCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.CREATE, pageId, true);
        this.actionPanel.add(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435502L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)LoggerCategoryPanel.this.custom.getModelObject()))) {
                    Map.Entry parsed = LoggerEventUtils.parseEventCategory((String)((String)LoggerCategoryPanel.this.custom.getModelObject()));
                    String eventString = LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)((EventCategoryTO)parsed.getKey()).getType(), null, null, (String)(((EventCategoryTO)parsed.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategoryTO)parsed.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)parsed.getValue()));
                    LoggerCategoryPanel.this.custom.setModelObject("");
                    LoggerCategoryPanel.this.send((IEventSink)LoggerCategoryPanel.this.getPage(), Broadcast.BREADTH, new SelectedEventsPanel.EventSelectionChanged(target, Collections.<String>emptySet(), Collections.singleton(eventString)));
                    target.add(new Component[]{LoggerCategoryPanel.this.categoryContainer});
                }
            }
        }, ActionLink.ActionType.DELETE, pageId, true);
        this.actionPanel.setVisible(false);
        this.actionPanel.setEnabled(false);
        this.eventsContainer.add(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategoryTO, model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            protected void onEventAction(IEvent<?> event) {
                LoggerCategoryPanel.this.onEventAction(event);
            }
        }});
    }

    private List<String> filter(List<EventCategoryTO> eventCategoryTOs, AuditElements.EventCategoryType type) {
        HashSet<String> res = new HashSet<String>();
        for (EventCategoryTO eventCategory : eventCategoryTOs) {
            if (type != eventCategory.getType() || !StringUtils.isNotEmpty((CharSequence)eventCategory.getCategory())) continue;
            res.add(eventCategory.getCategory());
        }
        ArrayList<String> filtered = new ArrayList<String>(res);
        Collections.sort(filtered);
        return filtered;
    }

    private List<String> filter(List<EventCategoryTO> eventCategoryTOs, AuditElements.EventCategoryType type, String category) {
        HashSet<String> res = new HashSet<String>();
        for (EventCategoryTO eventCategory : eventCategoryTOs) {
            if (type != eventCategory.getType() || !StringUtils.equals((CharSequence)category, (CharSequence)eventCategory.getCategory()) || !StringUtils.isNotEmpty((CharSequence)eventCategory.getSubcategory())) continue;
            res.add(eventCategory.getSubcategory());
        }
        ArrayList<String> filtered = new ArrayList<String>(res);
        Collections.sort(filtered);
        return filtered;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ChangeCategoryEvent) {
            this.eventCategoryTO.getEvents().clear();
            ChangeCategoryEvent change = (ChangeCategoryEvent)event.getPayload();
            Panel changedPanel = change.getChangedPanel();
            if ("type".equals(changedPanel.getId())) {
                this.eventCategoryTO.setType((AuditElements.EventCategoryType)this.type.getModelObject());
                this.eventCategoryTO.setCategory(null);
                this.eventCategoryTO.setSubcategory(null);
                if (this.type.getModelObject() == AuditElements.EventCategoryType.CUSTOM) {
                    this.category.setChoices(Collections.emptyList());
                    this.subcategory.setChoices(Collections.emptyList());
                    this.category.setEnabled(false);
                    this.subcategory.setEnabled(false);
                    this.custom.setVisible(true);
                    this.custom.setEnabled(true);
                    this.actionPanel.setVisible(true);
                    this.actionPanel.setEnabled(true);
                } else {
                    this.category.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
                    this.subcategory.setChoices(Collections.emptyList());
                    this.category.setEnabled(true);
                    this.subcategory.setEnabled(true);
                    this.custom.setVisible(false);
                    this.custom.setEnabled(false);
                    this.actionPanel.setVisible(false);
                    this.actionPanel.setEnabled(false);
                }
                change.getTarget().add(new Component[]{this.categoryContainer});
            } else if ("category".equals(changedPanel.getId())) {
                this.subcategory.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
                this.eventCategoryTO.setCategory((String)this.category.getModelObject());
                this.eventCategoryTO.setSubcategory(null);
                change.getTarget().add(new Component[]{this.categoryContainer});
            } else {
                this.eventCategoryTO.setSubcategory((String)this.subcategory.getModelObject());
            }
            this.updateEventsContainer(change.getTarget());
        } else if (event.getPayload() instanceof SelectedEventsPanel.InspectSelectedEvent) {
            this.eventCategoryTO.getEvents().clear();
            SelectedEventsPanel.InspectSelectedEvent inspectSelectedEvent = (SelectedEventsPanel.InspectSelectedEvent)event.getPayload();
            Map.Entry categoryEvent = LoggerEventUtils.parseEventCategory((String)inspectSelectedEvent.getEvent());
            this.eventCategoryTO.setType(((EventCategoryTO)categoryEvent.getKey()).getType());
            this.category.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject()));
            this.eventCategoryTO.setCategory(((EventCategoryTO)categoryEvent.getKey()).getCategory());
            this.subcategory.setChoices(this.filter(this.eventCategoryTOs, (AuditElements.EventCategoryType)this.type.getModelObject(), (String)this.category.getModelObject()));
            this.eventCategoryTO.setSubcategory(((EventCategoryTO)categoryEvent.getKey()).getSubcategory());
            if (((EventCategoryTO)categoryEvent.getKey()).getType() == AuditElements.EventCategoryType.CUSTOM) {
                this.custom.setModelObject(LoggerEventUtils.buildEvent((AuditElements.EventCategoryType)((EventCategoryTO)categoryEvent.getKey()).getType(), (String)((EventCategoryTO)categoryEvent.getKey()).getCategory(), (String)((EventCategoryTO)categoryEvent.getKey()).getSubcategory(), (String)(((EventCategoryTO)categoryEvent.getKey()).getEvents().isEmpty() ? "" : (String)((EventCategoryTO)categoryEvent.getKey()).getEvents().iterator().next()), (AuditElements.Result)((AuditElements.Result)categoryEvent.getValue())));
                this.category.setEnabled(false);
                this.subcategory.setEnabled(false);
                this.custom.setVisible(true);
                this.custom.setEnabled(true);
                this.actionPanel.setVisible(true);
                this.actionPanel.setEnabled(true);
            } else {
                this.category.setEnabled(true);
                this.subcategory.setEnabled(true);
                this.custom.setVisible(false);
                this.custom.setEnabled(false);
                this.actionPanel.setVisible(false);
                this.actionPanel.setEnabled(false);
            }
            inspectSelectedEvent.getTarget().add(new Component[]{this.categoryContainer});
            this.updateEventsContainer(inspectSelectedEvent.getTarget());
        }
    }

    private void setEvents() {
        Iterator<EventCategoryTO> itor = this.eventCategoryTOs.iterator();
        while (itor.hasNext() && this.eventCategoryTO.getEvents().isEmpty()) {
            EventCategoryTO eventCategory = itor.next();
            if (eventCategory.getType() != this.eventCategoryTO.getType() || !StringUtils.equals((CharSequence)eventCategory.getCategory(), (CharSequence)this.eventCategoryTO.getCategory()) || !StringUtils.equals((CharSequence)eventCategory.getSubcategory(), (CharSequence)this.eventCategoryTO.getSubcategory())) continue;
            this.eventCategoryTO.getEvents().addAll(eventCategory.getEvents());
        }
    }

    protected void onEventAction(IEvent<?> event) {
    }

    private void authorizeList() {
        for (String role : this.getListRoles()) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.selectedEventsPanel, (Action)RENDER, (String)role);
        }
    }

    private void authorizeChanges() {
        for (String role : this.getChangeRoles()) {
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.categoryContainer, (Action)RENDER, (String)role);
            MetaDataRoleAuthorizationStrategy.authorize((Component)this.eventsContainer, (Action)RENDER, (String)role);
        }
    }

    private void updateEventsContainer(AjaxRequestTarget target) {
        this.setEvents();
        this.eventsContainer.addOrReplace(new Component[]{new EventSelectionPanel("eventsPanel", this.eventCategoryTO, this.model){
            private static final long serialVersionUID = 3513194801190026082L;

            @Override
            public void onEventAction(IEvent<?> event) {
                LoggerCategoryPanel.this.onEventAction(event);
            }
        }});
        target.add(new Component[]{this.eventsContainer});
    }

    protected abstract String[] getListRoles();

    protected abstract String[] getChangeRoles();

    private class ChangeCategoryEvent {
        private final AjaxRequestTarget target;
        private final Panel changedPanel;

        public ChangeCategoryEvent(AjaxRequestTarget target, Panel changedPanel) {
            this.target = target;
            this.changedPanel = changedPanel;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public Panel getChangedPanel() {
            return this.changedPanel;
        }
    }
}

