/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.commons.RoleTreeBuilder;
import org.apache.syncope.console.commons.RoleUtils;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.MembershipModalPage;
import org.apache.syncope.console.pages.UserModalPage;
import org.apache.syncope.console.pages.panels.StatusPanel;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.ajax.markup.html.IndicatingOnConfirmAjaxLink;
import org.apache.syncope.console.wicket.markup.html.tree.DefaultMutableTreeNodeExpansion;
import org.apache.syncope.console.wicket.markup.html.tree.DefaultMutableTreeNodeExpansionModel;
import org.apache.syncope.console.wicket.markup.html.tree.TreeRoleProvider;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.DefaultNestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.NestedTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.content.Folder;
import org.apache.wicket.extensions.markup.html.repeater.tree.theme.WindowsTheme;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class MembershipsPanel
extends Panel {
    private static final long serialVersionUID = -2559791301973107191L;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private final ListView<MembershipTO> membView;
    private final UserTO userTO;
    private final StatusPanel statusPanel;
    private final NestedTree<DefaultMutableTreeNode> tree;

    public MembershipsPanel(String id, final UserTO userTO, final Mode mode, final StatusPanel statusPanel, final PageReference pageRef) {
        super(id);
        this.userTO = userTO;
        this.statusPanel = statusPanel;
        final WebMarkupContainer membershipsContainer = new WebMarkupContainer("membershipsContainer");
        membershipsContainer.setOutputMarkupId(true);
        this.add(new Component[]{membershipsContainer});
        final ModalWindow membWin = new ModalWindow("membershipWin");
        membWin.setCssClassName("w_silver");
        membWin.setCookieName("create-membership-modal");
        this.add(new Component[]{membWin});
        TreeRoleProvider treeProvider = new TreeRoleProvider(this.roleTreeBuilder, true);
        DefaultMutableTreeNodeExpansionModel treeModel = new DefaultMutableTreeNodeExpansionModel();
        this.tree = new DefaultNestedTree<DefaultMutableTreeNode>("treeTable", (ITreeProvider)treeProvider, (IModel)treeModel){
            private static final long serialVersionUID = 7137658050662575546L;

            protected Component newContentComponent(String id, IModel<DefaultMutableTreeNode> node) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node.getObject();
                final RoleTO roleTO = (RoleTO)treeNode.getUserObject();
                return new Folder<DefaultMutableTreeNode>(id, (AbstractTree)MembershipsPanel.this.tree, node){
                    private static final long serialVersionUID = 9046323319920426493L;

                    protected boolean isClickable() {
                        return true;
                    }

                    protected IModel<?> newLabelModel(IModel<DefaultMutableTreeNode> model) {
                        return new Model((Serializable)((Object)roleTO.getDisplayName()));
                    }

                    protected void onClick(AjaxRequestTarget target) {
                        if (roleTO.getId() > 0L) {
                            membWin.setPageCreator(new ModalWindow.PageCreator(){
                                private static final long serialVersionUID = 7661763358801821185L;

                                public Page createPage() {
                                    PageReference pageRef = this.getPage().getPageReference();
                                    for (MembershipTO membTO : MembershipsPanel.this.membView.getList()) {
                                        if (membTO.getRoleId() != roleTO.getId()) continue;
                                        return new MembershipModalPage(pageRef, membWin, membTO, mode);
                                    }
                                    MembershipTO membTO = new MembershipTO();
                                    membTO.setRoleId(roleTO.getId());
                                    membTO.setRoleName(roleTO.getName());
                                    return new MembershipModalPage(pageRef, membWin, membTO, mode);
                                }
                            });
                            membWin.show(target);
                        }
                    }
                };
            }
        };
        this.tree.add(new Behavior[]{new WindowsTheme()});
        this.tree.setOutputMarkupId(true);
        DefaultMutableTreeNodeExpansion.get().expandAll();
        this.add(new Component[]{this.tree});
        this.membView = new ListView<MembershipTO>("memberships", (IModel)new PropertyModel((Object)userTO, "memberships")){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getDefaultModelObject();
                item.add(new Component[]{new Label("roleId", (IModel)new Model((Serializable)Long.valueOf(membershipTO.getRoleId())))});
                item.add(new Component[]{new Label("roleName", (IModel)new Model((Serializable)((Object)membershipTO.getRoleName())))});
                ClearIndicatingAjaxLink editLink = new ClearIndicatingAjaxLink("editLink", pageRef){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    protected void onClickInternal(AjaxRequestTarget target) {
                        membWin.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new MembershipModalPage(this.getPage().getPageReference(), membWin, membershipTO, mode);
                            }
                        });
                        membWin.show(target);
                    }
                };
                item.add(new Component[]{editLink});
                IndicatingOnConfirmAjaxLink deleteLink = new IndicatingOnConfirmAjaxLink("deleteLink", pageRef){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    protected void onClickInternal(AjaxRequestTarget target) {
                        Set resourcesToRemove;
                        userTO.getMemberships().remove(membershipTO);
                        ((UserModalPage)this.getPage()).getUserTO().getMemberships().remove(membershipTO);
                        target.add(new Component[]{membershipsContainer});
                        RoleTO roleTO = RoleUtils.findRole(MembershipsPanel.this.roleTreeBuilder, membershipTO.getRoleId());
                        Set set = resourcesToRemove = roleTO == null ? Collections.emptySet() : roleTO.getResources();
                        if (!resourcesToRemove.isEmpty()) {
                            HashSet resourcesAssignedViaMembership = new HashSet();
                            for (MembershipTO membTO : userTO.getMemberships()) {
                                roleTO = RoleUtils.findRole(MembershipsPanel.this.roleTreeBuilder, membTO.getRoleId());
                                if (roleTO == null) continue;
                                resourcesAssignedViaMembership.addAll(roleTO.getResources());
                            }
                            resourcesToRemove.removeAll(resourcesAssignedViaMembership);
                            resourcesToRemove.removeAll(userTO.getResources());
                        }
                        StatusUtils.update((AbstractAttributableTO)userTO, statusPanel, target, Collections.<String>emptySet(), resourcesToRemove);
                    }
                };
                item.add(new Component[]{deleteLink});
            }
        };
        membershipsContainer.add(new Component[]{this.membView});
        this.setWindowClosedCallback(membWin, membershipsContainer);
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                UserTO updatedUserTO = ((UserModalPage)MembershipsPanel.this.getPage()).getUserTO();
                if (!MembershipsPanel.this.userTO.equals((Object)updatedUserTO)) {
                    if (updatedUserTO.getMemberships().size() > MembershipsPanel.this.userTO.getMemberships().size()) {
                        HashSet diff = new HashSet(updatedUserTO.getMembershipMap().keySet());
                        diff.removeAll(MembershipsPanel.this.userTO.getMembershipMap().keySet());
                        HashSet<String> resourcesToAdd = new HashSet<String>();
                        for (Long diffMembId : diff) {
                            long roleId = ((MembershipTO)updatedUserTO.getMembershipMap().get(diffMembId)).getRoleId();
                            RoleTO roleTO = RoleUtils.findRole(MembershipsPanel.this.roleTreeBuilder, roleId);
                            resourcesToAdd.addAll(roleTO.getResources());
                            StatusUtils.update((AbstractAttributableTO)MembershipsPanel.this.userTO, MembershipsPanel.this.statusPanel, target, resourcesToAdd, Collections.<String>emptySet());
                        }
                    }
                    MembershipsPanel.this.userTO.getMemberships().clear();
                    MembershipsPanel.this.userTO.getMemberships().addAll(updatedUserTO.getMemberships());
                    target.add(new Component[]{container});
                }
            }
        });
    }
}

