/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class NotificationPanel
extends FeedbackPanel {
    private static final long serialVersionUID = 5895940553202128621L;
    private static final String CSS_CLASS = "notificationpanel";
    private static final String DEFAULT_ADDITIONAL_CSS_CLASS = "notificationpanel_top_right";
    private final String additionalCSSClass;

    public NotificationPanel(String id) {
        this(id, null, null);
    }

    public NotificationPanel(String id, String additionalCSSClass, IFeedbackMessageFilter feedbackMessageFilter) {
        super(id, feedbackMessageFilter);
        this.add(new Behavior[]{new AjaxEventBehavior("onclick"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                target.appendJavaScript((CharSequence)("setTimeout(\"$('div#" + NotificationPanel.this.getMarkupId() + "').fadeOut('normal')\", 0);"));
            }
        }});
        this.additionalCSSClass = StringUtils.isBlank((CharSequence)additionalCSSClass) ? DEFAULT_ADDITIONAL_CSS_CLASS : additionalCSSClass;
        this.setMarkupId(id);
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)("notificationpanel " + this.additionalCSSClass))))});
        this.add(new Behavior[]{new AttributeModifier("style", (IModel)new Model((Serializable)((Object)"opacity: 0;")))});
    }

    public void refresh(AjaxRequestTarget target) {
        if (this.anyMessage()) {
            int highestFeedbackLevel = 200;
            if (this.anyMessage(300)) {
                highestFeedbackLevel = 300;
            }
            if (this.anyMessage(400)) {
                highestFeedbackLevel = 400;
            }
            this.add(new Behavior[]{new AttributeModifier("class", (IModel)new Model((Serializable)((Object)("notificationpanel " + this.additionalCSSClass + " notificationpanel_border_" + highestFeedbackLevel))))});
            target.add(new Component[]{this});
            if (this.anyMessage(400)) {
                target.appendJavaScript((CharSequence)("$('div#" + this.getMarkupId() + "').fadeTo('normal', 1.0);"));
            } else {
                target.appendJavaScript((CharSequence)("showNotification('" + this.getMarkupId() + "', " + this.getCurrentMessages().size() + ");"));
            }
        }
    }

    protected String getCSSClass(FeedbackMessage message) {
        return "notificationpanel_row_" + message.getLevelAsString();
    }
}

