/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.NotificationTaskTO;
import org.apache.syncope.console.pages.NotificationTaskModalPage;
import org.apache.syncope.console.pages.Tasks;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.AbstractTasks;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.JobColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;

public class NotificationTasks
extends AbstractTasks {
    private static final long serialVersionUID = 4984337552918213290L;
    private int paginatorRows;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private boolean operationResult = false;
    private ModalWindow window;
    private AjaxDataTablePanel<AbstractTaskTO, String> table;

    public NotificationTasks(String id, final PageReference pageRef) {
        super(id, pageRef);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "notificationtasks.paginator.rows");
        this.table = Tasks.updateTaskTable(this.getColumns(), new Tasks.TasksProvider<NotificationTaskTO>(this.restClient, this.paginatorRows, this.getId(), NotificationTaskTO.class), this.container, 0, pageRef, this.restClient);
        this.container.add(new Component[]{this.table});
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{NotificationTasks.this.container});
                if (NotificationTasks.this.operationResult) {
                    NotificationTasks.this.info((Serializable)((Object)NotificationTasks.this.getString("operation_succeeded")));
                    target.add(new Component[]{NotificationTasks.this.getPage().get("feedback")});
                    NotificationTasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                NotificationTasks.this.prefMan.set((Request)NotificationTasks.this.getWebRequest(), (Response)((WebResponse)NotificationTasks.this.getResponse()), "notificationtasks.paginator.rows", String.valueOf(NotificationTasks.this.paginatorRows));
                NotificationTasks.this.table = Tasks.updateTaskTable(NotificationTasks.this.getColumns(), new Tasks.TasksProvider<NotificationTaskTO>(NotificationTasks.this.restClient, NotificationTasks.this.paginatorRows, NotificationTasks.this.getId(), NotificationTaskTO.class), NotificationTasks.this.container, NotificationTasks.this.table == null ? 0 : (int)NotificationTasks.this.table.getCurrentPage(), pageRef, NotificationTasks.this.restClient);
                target.add(new Component[]{NotificationTasks.this.container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private List<IColumn<AbstractTaskTO, String>> getColumns() {
        ArrayList<IColumn<AbstractTaskTO, String>> columns = new ArrayList<IColumn<AbstractTaskTO, String>>();
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("sender", (Component)this, null, new Object[0]), (Object)"sender", "sender"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("recipients", (Component)this, null, new Object[0]), (Object)"recipients", "recipients"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("subject", (Component)this, null, new Object[0]), (Object)"subject", "subject"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("traceLevel", (Component)this, null, new Object[0]), (Object)"traceLevel", "traceLevel"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this, null, new Object[0]), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<AbstractTaskTO, String>)new JobColumn((IModel<String>)new StringResourceModel("", (Component)this, null, "", new Object[0]), "runtime", this.pageRef, this.restClient));
        columns.add((IColumn<AbstractTaskTO, String>)new ActionColumn<AbstractTaskTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<AbstractTaskTO> model) {
                final AbstractTaskTO taskTO = (AbstractTaskTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, NotificationTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        NotificationTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new NotificationTaskModalPage(taskTO);
                            }
                        });
                        NotificationTasks.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            NotificationTasks.this.restClient.startExecution(taskTO.getId(), false);
                            NotificationTasks.this.getSession().info((Serializable)((Object)NotificationTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            NotificationTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        ((NotificationPanel)NotificationTasks.this.getPage().get("feedback")).refresh(target);
                        target.add(new Component[]{NotificationTasks.this.container});
                    }
                }, ActionLink.ActionType.EXECUTE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            NotificationTasks.this.restClient.delete(taskTO.getId(), NotificationTaskTO.class);
                            NotificationTasks.this.info((Serializable)((Object)NotificationTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            NotificationTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{NotificationTasks.this.container});
                        ((NotificationPanel)NotificationTasks.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), NotificationTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{NotificationTasks.this.table});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        return columns;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AbstractSearchResultPanel.EventDataWrapper) {
            ((AbstractSearchResultPanel.EventDataWrapper)event.getPayload()).getTarget().add(new Component[]{this.container});
        }
    }
}

