/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractPolicyTO;
import org.apache.syncope.common.to.AccountPolicyTO;
import org.apache.syncope.common.to.PasswordPolicyTO;
import org.apache.syncope.common.to.SyncPolicyTO;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.console.commons.PreferenceManager;
import org.apache.syncope.console.commons.SortableDataProviderComparator;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.BasePage;
import org.apache.syncope.console.pages.PolicyModalPage;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.rest.PolicyRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.ajax.markup.html.repeater.data.table.AjaxFallbackDefaultDataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.ISortableDataProvider;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoliciesPanel
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(PoliciesPanel.class);
    private static final int MODAL_WIN_HEIGHT = 400;
    private static final int MODAL_WIN_WIDTH = 1000;
    private static final long serialVersionUID = -6804066913177804275L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    @SpringBean
    protected XMLRolesReader xmlRolesReader;
    @SpringBean
    private PreferenceManager prefMan;
    private final PageReference pageRef;
    private final int paginatorRows;
    protected boolean modalResult;
    private final PolicyType policyType;

    public PoliciesPanel(String id, final PageReference pageRef, final PolicyType policyType) {
        super(id);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "policy.paginator.rows");
        this.modalResult = false;
        this.pageRef = pageRef;
        this.policyType = policyType;
        final ModalWindow mwindow = new ModalWindow("editModalWin");
        mwindow.setCssClassName("w_silver");
        mwindow.setInitialHeight(400);
        mwindow.setInitialWidth(1000);
        mwindow.setCookieName("policy-modal");
        this.add(new Component[]{mwindow});
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.setWindowClosedCallback(mwindow, container);
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new PropertyColumn((IModel)new ResourceModel("id"), (Object)"id", "id"));
        columns.add(new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        columns.add(new AbstractColumn<AbstractPolicyTO, String>((IModel)new ResourceModel("type")){
            private static final long serialVersionUID = 8263694778917279290L;

            public void populateItem(Item<ICellPopulator<AbstractPolicyTO>> cellItem, String componentId, IModel<AbstractPolicyTO> model) {
                cellItem.add(new Component[]{new Label(componentId, PoliciesPanel.this.getString(((AbstractPolicyTO)model.getObject()).getType().name()))});
            }
        });
        columns.add(new AbstractColumn<AbstractPolicyTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = 2054811145491901166L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<AbstractPolicyTO>> cellItem, String componentId, IModel<AbstractPolicyTO> model) {
                final AbstractPolicyTO policyTO = (AbstractPolicyTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        mwindow.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new PolicyModalPage<AbstractPolicyTO>(pageRef, mwindow, policyTO);
                            }
                        });
                        mwindow.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Policies");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PoliciesPanel.this.policyRestClient.delete(policyTO.getId(), policyTO.getClass());
                            PoliciesPanel.this.info((Serializable)((Object)PoliciesPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException e) {
                            PoliciesPanel.this.error((Serializable)((Object)PoliciesPanel.this.getString("operation_error")));
                            LOG.error("While deleting policy {}({})", new Object[]{policyTO.getId(), policyTO.getDescription(), e});
                        }
                        target.add(new Component[]{container});
                        ((NotificationPanel)PoliciesPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Policies");
                cellItem.add(new Component[]{panel});
            }
        });
        final AjaxFallbackDefaultDataTable table = new AjaxFallbackDefaultDataTable("datatable", columns, (ISortableDataProvider)new PolicyDataProvider(), this.paginatorRows);
        container.add(new Component[]{table});
        ClearIndicatingAjaxLink<Void> createButton = new ClearIndicatingAjaxLink<Void>("createLink", pageRef){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                mwindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new PolicyModalPage<AbstractPolicyTO>(pageRef, mwindow, PoliciesPanel.this.getPolicyTOInstance(policyType));
                    }
                });
                mwindow.show(target);
            }
        };
        this.add(new Component[]{createButton});
        MetaDataRoleAuthorizationStrategy.authorize((Component)createButton, (Action)ENABLE, (String)this.xmlRolesReader.getEntitlement("Policies", "create"));
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PoliciesPanel.this.prefMan.set((Request)PoliciesPanel.this.getWebRequest(), (Response)((WebResponse)PoliciesPanel.this.getResponse()), "policy.paginator.rows", String.valueOf(PoliciesPanel.this.paginatorRows));
                table.setItemsPerPage((long)PoliciesPanel.this.paginatorRows);
                target.add(new Component[]{container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private void setWindowClosedCallback(ModalWindow window, final WebMarkupContainer container) {
        window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{container});
                BasePage configuration = (BasePage)PoliciesPanel.this.pageRef.getPage();
                if (configuration.isModalResult()) {
                    PoliciesPanel.this.info((Serializable)((Object)PoliciesPanel.this.getString("operation_succeeded")));
                    configuration.getFeedbackPanel().refresh(target);
                    configuration.setModalResult(false);
                }
            }
        });
    }

    private AbstractPolicyTO getPolicyTOInstance(PolicyType policyType) {
        AccountPolicyTO policyTO;
        switch (policyType) {
            case GLOBAL_ACCOUNT: {
                policyTO = new AccountPolicyTO(true);
                break;
            }
            case ACCOUNT: {
                policyTO = new AccountPolicyTO();
                break;
            }
            case GLOBAL_PASSWORD: {
                policyTO = new PasswordPolicyTO(true);
                break;
            }
            case PASSWORD: {
                policyTO = new PasswordPolicyTO();
                break;
            }
            case GLOBAL_SYNC: {
                policyTO = new SyncPolicyTO(true);
                break;
            }
            default: {
                policyTO = new SyncPolicyTO();
            }
        }
        return policyTO;
    }

    private class PolicyDataProvider
    extends SortableDataProvider<AbstractPolicyTO, String> {
        private static final long serialVersionUID = -6976327453925166730L;
        private final SortableDataProviderComparator<AbstractPolicyTO> comparator;

        public PolicyDataProvider() {
            this.setSort("description", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<AbstractPolicyTO>(this);
        }

        public long size() {
            return PoliciesPanel.this.policyRestClient.getPolicies(PoliciesPanel.this.policyType, true).size();
        }

        public Iterator<AbstractPolicyTO> iterator(long first, long count) {
            List policies = PoliciesPanel.this.policyRestClient.getPolicies(PoliciesPanel.this.policyType, true);
            Collections.sort(policies, this.comparator);
            return policies.subList((int)first, (int)first + (int)count).iterator();
        }

        public IModel<AbstractPolicyTO> model(AbstractPolicyTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

