/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.annotation.ClassList;
import org.apache.syncope.common.annotation.SchemaList;
import org.apache.syncope.common.types.AbstractPolicySpec;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.rest.PolicyRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;

public class PolicyBeanPanel
extends Panel {
    private static final long serialVersionUID = -3035998190456928143L;
    private static final Logger LOG = LoggerFactory.getLogger(PolicyBeanPanel.class);
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private PolicyRestClient policyRestClient;
    final IModel<List<String>> userSchemas = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected List<String> load() {
            return PolicyBeanPanel.this.schemaRestClient.getSchemaNames(AttributableType.USER);
        }
    };
    final IModel<List<String>> roleSchemas = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return PolicyBeanPanel.this.schemaRestClient.getSchemaNames(AttributableType.ROLE);
        }
    };
    final IModel<List<String>> correlationRules = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return PolicyBeanPanel.this.policyRestClient.getCorrelationRuleClasses();
        }
    };

    public PolicyBeanPanel(String id, final AbstractPolicySpec policy) {
        super(id);
        ArrayList<FieldWrapper> items = new ArrayList<FieldWrapper>();
        for (Field field : policy.getClass().getDeclaredFields()) {
            if ("serialVersionUID".equals(field.getName())) continue;
            FieldWrapper fieldWrapper = new FieldWrapper();
            fieldWrapper.setName(field.getName());
            fieldWrapper.setType(field.getType());
            SchemaList schemaList = field.getAnnotation(SchemaList.class);
            fieldWrapper.setSchemaList(schemaList);
            ClassList classList = field.getAnnotation(ClassList.class);
            fieldWrapper.setClassList(classList);
            items.add(fieldWrapper);
        }
        AltListView<FieldWrapper> policies = new AltListView<FieldWrapper>("policies", items){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<FieldWrapper> item) {
                FieldWrapper field = (FieldWrapper)item.getModelObject();
                PropertyDescriptor propDesc = BeanUtils.getPropertyDescriptor(policy.getClass(), (String)field.getName());
                item.add(new Component[]{new Label("label", (IModel)new ResourceModel(field.getName()))});
                try {
                    if (field.getClassList() != null) {
                        AjaxDropDownChoicePanel component = new AjaxDropDownChoicePanel("field", field.getName(), new PropertyModel((Object)policy, field.getName()));
                        List rules = (List)PolicyBeanPanel.this.correlationRules.getObject();
                        if (rules != null && !rules.isEmpty()) {
                            component.setChoices((List)PolicyBeanPanel.this.correlationRules.getObject());
                        }
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, propDesc.getReadMethod().invoke((Object)policy, new Object[0]) != null, null, null)});
                    } else if (field.getType().isEnum()) {
                        AjaxDropDownChoicePanel<Serializable> component = new AjaxDropDownChoicePanel<Serializable>("field", field.getName(), (IModel<Serializable>)new PropertyModel((Object)policy, field.getName()));
                        Serializable[] values = (Serializable[])field.getType().getEnumConstants();
                        if (values != null && values.length > 0) {
                            component.setChoices(Arrays.asList(values));
                        }
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, (Enum)propDesc.getReadMethod().invoke((Object)policy, new Object[0]) != null, values[0], values[0])});
                    } else if (ClassUtils.isAssignable(Boolean.class, field.getType())) {
                        item.add(new Component[]{new AjaxCheckBoxPanel("check", field.getName(), (IModel<Boolean>)new PropertyModel((Object)policy, field.getName()))});
                        item.add(new Component[]{new Label("field", (IModel)new Model(null))});
                    } else if (Collection.class.isAssignableFrom(field.getType())) {
                        if (field.getSchemaList() != null) {
                            ArrayList<String> values = new ArrayList<String>();
                            if (field.getName().charAt(0) == 'r') {
                                values.addAll((Collection)PolicyBeanPanel.this.roleSchemas.getObject());
                                if (field.getSchemaList().extended()) {
                                    values.add("name");
                                }
                            } else {
                                values.addAll((Collection)PolicyBeanPanel.this.userSchemas.getObject());
                                if (field.getSchemaList().extended()) {
                                    values.add("id");
                                    values.add("username");
                                }
                            }
                            AjaxPalettePanel component = new AjaxPalettePanel("field", new PropertyModel((Object)policy, field.getName()), new ListModel(values));
                            item.add(new Component[]{component});
                            Collection collection = (Collection)propDesc.getReadMethod().invoke((Object)policy, new Object[0]);
                            item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, !collection.isEmpty(), new ArrayList(), new ArrayList())});
                        } else {
                            AjaxTextFieldPanel panel = new AjaxTextFieldPanel("panel", field.getName(), (IModel<String>)new Model(null));
                            panel.setRequired(true);
                            MultiFieldPanel<String> component = new MultiFieldPanel<String>("field", (IModel<List<String>>)new PropertyModel((Object)policy, field.getName()), panel);
                            item.add(new Component[]{component});
                            ArrayList<String> reinitializedValue = new ArrayList<String>();
                            reinitializedValue.add("");
                            item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, !((Collection)propDesc.getReadMethod().invoke((Object)policy, new Object[0])).isEmpty(), new ArrayList(), reinitializedValue)});
                        }
                    } else if (ClassUtils.isAssignable(Number.class, field.getType())) {
                        SpinnerFieldPanel<Object> component = new SpinnerFieldPanel<Object>("field", field.getName(), (Class<Object>)field.getType(), (IModel<Object>)new PropertyModel((Object)policy, field.getName()), null, null);
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, (Integer)propDesc.getReadMethod().invoke((Object)policy, new Object[0]) > 0, Integer.valueOf(0), Integer.valueOf(0))});
                    } else if (field.getType().equals(String.class)) {
                        AjaxTextFieldPanel component = new AjaxTextFieldPanel("field", field.getName(), (IModel<String>)new PropertyModel((Object)policy, field.getName()));
                        item.add(new Component[]{component});
                        item.add(new Component[]{PolicyBeanPanel.this.getActivationControl(component, propDesc.getReadMethod().invoke((Object)policy, new Object[0]) != null, null, null)});
                    } else {
                        item.add(new Component[]{new AjaxCheckBoxPanel("check", field.getName(), (IModel<Boolean>)new Model())});
                        item.add(new Component[]{new Label("field", (IModel)new Model(null))});
                    }
                }
                catch (Exception e) {
                    LOG.error("Error retrieving policy fields", (Throwable)e);
                }
            }
        };
        this.add(new Component[]{policies});
    }

    private <T extends Serializable> AjaxCheckBoxPanel getActivationControl(final AbstractFieldPanel<T> panel, Boolean checked, final T defaultModelObject, final T reinitializedValue) {
        final AjaxCheckBoxPanel check = new AjaxCheckBoxPanel("check", "check", (IModel<Boolean>)new Model((Serializable)checked));
        panel.setEnabled(checked);
        check.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)check.getModelObject()).booleanValue()) {
                    panel.setEnabled(true);
                    panel.setModelObject(reinitializedValue);
                } else {
                    panel.setModelObject(defaultModelObject);
                    panel.setEnabled(false);
                }
                target.add(new Component[]{panel});
            }
        }});
        return check;
    }

    private static class FieldWrapper
    implements Serializable {
        private static final long serialVersionUID = -6770429509752964215L;
        private Class<?> type;
        private String name;
        private transient SchemaList schemaList;
        private transient ClassList classList;

        private FieldWrapper() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public SchemaList getSchemaList() {
            return this.schemaList;
        }

        public void setSchemaList(SchemaList schemaList) {
            this.schemaList = schemaList;
        }

        public ClassList getClassList() {
            return this.classList;
        }

        public void setClassList(ClassList classList) {
            this.classList = classList;
        }
    }
}

