/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.PropagationTaskTO;
import org.apache.syncope.console.pages.PropagationTaskModalPage;
import org.apache.syncope.console.pages.Tasks;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.AbstractTasks;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;

public class PropagationTasks
extends AbstractTasks {
    private static final long serialVersionUID = 4984337552918213290L;
    private int paginatorRows;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private boolean operationResult = false;
    private final ModalWindow window;
    private AjaxDataTablePanel<AbstractTaskTO, String> table;

    public PropagationTasks(String id, final PageReference pageRef) {
        super(id, pageRef);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("taskWin");
        componentArray[0] = this.window;
        this.add(componentArray);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "proagationtasks.paginator.rows");
        this.table = Tasks.updateTaskTable(this.getColumns(), new Tasks.TasksProvider<PropagationTaskTO>(this.restClient, this.paginatorRows, this.getId(), PropagationTaskTO.class), this.container, 0, pageRef, this.restClient);
        this.window.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                target.add(new Component[]{PropagationTasks.this.container});
                if (PropagationTasks.this.operationResult) {
                    PropagationTasks.this.info((Serializable)((Object)PropagationTasks.this.getString("operation_succeeded")));
                    target.add(new Component[]{PropagationTasks.this.getPage().get("feedback")});
                    PropagationTasks.this.operationResult = false;
                }
            }
        });
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-task-win");
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                PropagationTasks.this.prefMan.set((Request)PropagationTasks.this.getWebRequest(), (Response)((WebResponse)PropagationTasks.this.getResponse()), "proagationtasks.paginator.rows", String.valueOf(PropagationTasks.this.paginatorRows));
                PropagationTasks.this.table = Tasks.updateTaskTable(PropagationTasks.this.getColumns(), new Tasks.TasksProvider<PropagationTaskTO>(PropagationTasks.this.restClient, PropagationTasks.this.paginatorRows, PropagationTasks.this.getId(), PropagationTaskTO.class), PropagationTasks.this.container, PropagationTasks.this.table == null ? 0 : (int)PropagationTasks.this.table.getCurrentPage(), pageRef, PropagationTasks.this.restClient);
                target.add(new Component[]{PropagationTasks.this.container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
    }

    private List<IColumn<AbstractTaskTO, String>> getColumns() {
        ArrayList<IColumn<AbstractTaskTO, String>> columns = new ArrayList<IColumn<AbstractTaskTO, String>>();
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("resource", (Component)this, null, new Object[0]), (Object)"resource", "resource"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("accountId", (Component)this, null, new Object[0]), (Object)"accountId", "accountId"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("propagationMode", (Component)this, null, new Object[0]), (Object)"propagationMode", "propagationMode"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("propagationOperation", (Component)this, null, new Object[0]), (Object)"propagationOperation", "propagationOperation"));
        columns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("startDate", (Component)this, null, new Object[0]), "startDate", "startDate"));
        columns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("endDate", (Component)this, null, new Object[0]), "endDate", "endDate"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this, null, new Object[0]), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<AbstractTaskTO, String>)new ActionColumn<AbstractTaskTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public String getCssClass() {
                return "action";
            }

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<AbstractTaskTO> model) {
                final AbstractTaskTO taskTO = (AbstractTaskTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, PropagationTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        PropagationTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new PropagationTaskModalPage(taskTO);
                            }
                        });
                        PropagationTasks.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PropagationTasks.this.restClient.startExecution(taskTO.getId(), false);
                            PropagationTasks.this.getSession().info((Serializable)((Object)PropagationTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            PropagationTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        ((NotificationPanel)PropagationTasks.this.getPage().get("feedback")).refresh(target);
                        target.add(new Component[]{PropagationTasks.this.container});
                    }
                }, ActionLink.ActionType.EXECUTE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PropagationTasks.this.restClient.delete(taskTO.getId(), PropagationTaskTO.class);
                            PropagationTasks.this.info((Serializable)((Object)PropagationTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            PropagationTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{PropagationTasks.this.container});
                        ((NotificationPanel)PropagationTasks.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), PropagationTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{PropagationTasks.this.table});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        return columns;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AbstractSearchResultPanel.EventDataWrapper) {
            ((AbstractSearchResultPanel.EventDataWrapper)event.getPayload()).getTarget().add(new Component[]{this.container});
        }
    }
}

