/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.PushTaskTO;
import org.apache.syncope.common.to.SyncTaskTO;
import org.apache.syncope.console.pages.PushTaskModalPage;
import org.apache.syncope.console.pages.panels.AbstractSyncTasksPanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class PushTasksPanel
extends AbstractSyncTasksPanel<PushTaskTO> {
    private static final long serialVersionUID = -2492299671757861889L;

    public PushTasksPanel(String id, PageReference pageRef) {
        super(id, pageRef, PushTaskTO.class);
        this.initTasksTable();
    }

    @Override
    protected List<IColumn<AbstractTaskTO, String>> getColumns() {
        ArrayList<IColumn<AbstractTaskTO, String>> pushTasksColumns = new ArrayList<IColumn<AbstractTaskTO, String>>();
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, new Object[0]), (Object)"name", "name"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("description", (Component)this, null, new Object[0]), (Object)"description", "description"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("resourceName", (Component)this, null, new Object[0]), (Object)"resource", "resource"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this, null, new Object[0]), "lastExec", "lastExec"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this, null, new Object[0]), "nextExec", "nextExec"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this, null, new Object[0]), (Object)"latestExecStatus", "latestExecStatus"));
        pushTasksColumns.add((IColumn<AbstractTaskTO, String>)new ActionColumn<AbstractTaskTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<AbstractTaskTO> model) {
                final PushTaskTO taskTO = (PushTaskTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, PushTasksPanel.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        PushTasksPanel.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new PushTaskModalPage(PushTasksPanel.this.window, taskTO, PushTasksPanel.this.pageRef);
                            }
                        });
                        PushTasksPanel.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PushTasksPanel.this.restClient.startExecution(taskTO.getId(), false);
                            PushTasksPanel.this.getSession().info((Serializable)((Object)PushTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            PushTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{PushTasksPanel.this.container});
                        ((NotificationPanel)PushTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.EXECUTE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PushTasksPanel.this.restClient.startExecution(taskTO.getId(), true);
                            PushTasksPanel.this.getSession().info((Serializable)((Object)PushTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            PushTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{PushTasksPanel.this.container});
                        ((NotificationPanel)PushTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DRYRUN, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            PushTasksPanel.this.restClient.delete(taskTO.getId(), SyncTaskTO.class);
                            PushTasksPanel.this.info((Serializable)((Object)PushTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            PushTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{PushTasksPanel.this.container});
                        ((NotificationPanel)PushTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), PushTasksPanel.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{PushTasksPanel.this.table});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        return pushTasksColumns;
    }
}

