/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.PropagationMode;
import org.apache.syncope.common.types.TraceLevel;
import org.apache.syncope.console.pages.ResourceModalPage;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.SpinnerFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDetailsPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDetailsPanel.class);
    @SpringBean
    private ConnectorRestClient connRestClient;
    private ConnInstanceTO connInstanceTO;

    public ResourceDetailsPanel(String id, final ResourceTO resourceTO, final List<String> actionClassNames, boolean createFlag) {
        super(id);
        this.setOutputMarkupId(true);
        AjaxTextFieldPanel resourceName = new AjaxTextFieldPanel("name", new ResourceModel("name", "name").getObject(), (IModel<String>)new PropertyModel((Object)resourceTO, "name"));
        resourceName.setEnabled(createFlag);
        resourceName.addRequiredLabel();
        this.add(new Component[]{resourceName});
        AjaxCheckBoxPanel enforceMandatoryCondition = new AjaxCheckBoxPanel("enforceMandatoryCondition", new ResourceModel("enforceMandatoryCondition", "enforceMandatoryCondition").getObject(), (IModel<Boolean>)new PropertyModel((Object)resourceTO, "enforceMandatoryCondition"));
        this.add(new Component[]{enforceMandatoryCondition});
        AjaxCheckBoxPanel propagationPrimary = new AjaxCheckBoxPanel("propagationPrimary", new ResourceModel("propagationPrimary", "propagationPrimary").getObject(), (IModel<Boolean>)new PropertyModel((Object)resourceTO, "propagationPrimary"));
        this.add(new Component[]{propagationPrimary});
        SpinnerFieldPanel<Object> propagationPriority = new SpinnerFieldPanel<Object>("propagationPriority", "propagationPriority", (Class<Object>)Integer.class, (IModel<Object>)new PropertyModel((Object)resourceTO, "propagationPriority"), null, null);
        this.add(new Component[]{propagationPriority});
        AjaxDropDownChoicePanel<PropagationMode> propagationMode = new AjaxDropDownChoicePanel<PropagationMode>("propagationMode", new ResourceModel("propagationMode", "propagationMode").getObject(), (IModel<PropagationMode>)new PropertyModel((Object)resourceTO, "propagationMode"));
        propagationMode.setChoices(Arrays.asList(PropagationMode.values()));
        this.add(new Component[]{propagationMode});
        AjaxCheckBoxPanel randomPwdIfNotProvided = new AjaxCheckBoxPanel("randomPwdIfNotProvided", new ResourceModel("randomPwdIfNotProvided", "randomPwdIfNotProvided").getObject(), (IModel<Boolean>)new PropertyModel((Object)resourceTO, "randomPwdIfNotProvided"));
        this.add(new Component[]{randomPwdIfNotProvided});
        final WebMarkupContainer propagationActionsClassNames = new WebMarkupContainer("propagationActionsClassNames");
        propagationActionsClassNames.setOutputMarkupId(true);
        this.add(new Component[]{propagationActionsClassNames});
        IndicatingAjaxLink<Void> first = new IndicatingAjaxLink<Void>("first"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                resourceTO.getPropagationActionsClassNames().add("");
                this.setVisible(false);
                target.add(new Component[]{propagationActionsClassNames});
            }
        };
        first.setOutputMarkupPlaceholderTag(true);
        first.setVisible(resourceTO.getPropagationActionsClassNames().isEmpty());
        propagationActionsClassNames.add(new Component[]{first});
        ListView<String> actionsClasses = new ListView<String>("actionsClasses", (IModel)new PropertyModel((Object)resourceTO, "propagationActionsClassNames"), (AjaxLink)first, propagationActionsClassNames){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ AjaxLink val$first;
            final /* synthetic */ WebMarkupContainer val$propagationActionsClassNames;
            {
                this.val$first = ajaxLink;
                this.val$propagationActionsClassNames = webMarkupContainer;
                super(x0, x1);
            }

            protected void populateItem(final ListItem<String> item) {
                final String className = (String)item.getModelObject();
                final DropDownChoice actionsClass = new DropDownChoice("actionsClass", (IModel)new Model((Serializable)((Object)className)), actionClassNames);
                actionsClass.setNullValid(true);
                actionsClass.setRequired(true);
                actionsClass.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        resourceTO.getPropagationActionsClassNames().set(item.getIndex(), actionsClass.getModelObject());
                    }
                }});
                actionsClass.setRequired(true);
                actionsClass.setOutputMarkupId(true);
                actionsClass.setRequired(true);
                item.add(new Component[]{actionsClass});
                IndicatingAjaxLink<Void> minus = new IndicatingAjaxLink<Void>("drop"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        resourceTO.getPropagationActionsClassNames().remove(className);
                        val$first.setVisible(resourceTO.getPropagationActionsClassNames().isEmpty());
                        target.add(new Component[]{val$propagationActionsClassNames});
                    }
                };
                item.add(new Component[]{minus});
                IndicatingAjaxLink<Void> plus = new IndicatingAjaxLink<Void>("add"){
                    private static final long serialVersionUID = -7978723352517770644L;

                    public void onClick(AjaxRequestTarget target) {
                        resourceTO.getPropagationActionsClassNames().add("");
                        target.add(new Component[]{val$propagationActionsClassNames});
                    }
                };
                plus.setOutputMarkupPlaceholderTag(true);
                plus.setVisible(item.getIndex() == resourceTO.getPropagationActionsClassNames().size() - 1);
                item.add(new Component[]{plus});
            }
        };
        propagationActionsClassNames.add(new Component[]{actionsClasses});
        AjaxDropDownChoicePanel<TraceLevel> createTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("createTraceLevel", new ResourceModel("createTraceLevel", "createTraceLevel").getObject(), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "createTraceLevel"));
        createTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        this.add(new Component[]{createTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> updateTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("updateTraceLevel", new ResourceModel("updateTraceLevel", "updateTraceLevel").getObject(), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "updateTraceLevel"));
        updateTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        this.add(new Component[]{updateTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> deleteTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("deleteTraceLevel", new ResourceModel("deleteTraceLevel", "deleteTraceLevel").getObject(), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "deleteTraceLevel"));
        deleteTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        this.add(new Component[]{deleteTraceLevel});
        AjaxDropDownChoicePanel<TraceLevel> syncTraceLevel = new AjaxDropDownChoicePanel<TraceLevel>("syncTraceLevel", new ResourceModel("syncTraceLevel", "syncTraceLevel").getObject(), (IModel<TraceLevel>)new PropertyModel((Object)resourceTO, "syncTraceLevel"));
        syncTraceLevel.setChoices(Arrays.asList(TraceLevel.values()));
        this.add(new Component[]{syncTraceLevel});
        LoadableDetachableModel<List<ConnInstanceTO>> connectors = new LoadableDetachableModel<List<ConnInstanceTO>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<ConnInstanceTO> load() {
                return ResourceDetailsPanel.this.connRestClient.getAllConnectors();
            }
        };
        this.connInstanceTO = this.getConectorInstanceTO((List)connectors.getObject(), resourceTO);
        AjaxDropDownChoicePanel conn = new AjaxDropDownChoicePanel("connector", new ResourceModel("connector", "connector").getObject(), new PropertyModel((Object)this, "connInstanceTO"));
        conn.setChoices((List)connectors.getObject());
        conn.setChoiceRenderer((IChoiceRenderer)new ChoiceRenderer("displayName", "id"));
        conn.getField().setModel((IModel)new IModel<ConnInstanceTO>(){
            private static final long serialVersionUID = -4202872830392400310L;

            public ConnInstanceTO getObject() {
                return ResourceDetailsPanel.this.connInstanceTO;
            }

            public void setObject(ConnInstanceTO connector) {
                resourceTO.setConnectorId(Long.valueOf(connector.getId()));
                ResourceDetailsPanel.this.connInstanceTO = connector;
            }

            public void detach() {
            }
        });
        conn.addRequiredLabel();
        conn.setEnabled(createFlag);
        conn.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ResourceDetailsPanel.this.send((IEventSink)ResourceDetailsPanel.this.getPage(), Broadcast.BREADTH, new DetailsModEvent(target));
            }
        }});
        this.add(new Component[]{conn});
    }

    private ConnInstanceTO getConectorInstanceTO(List<ConnInstanceTO> connectorTOs, ResourceTO resourceTO) {
        if (connectorTOs.isEmpty()) {
            resourceTO.setConnectorId(null);
            return null;
        }
        ConnInstanceTO res = connectorTOs.get(0);
        for (ConnInstanceTO to : connectorTOs) {
            if (!Long.valueOf(to.getId()).equals(resourceTO.getConnectorId())) continue;
            res = to;
        }
        resourceTO.setConnectorId(Long.valueOf(res.getId()));
        return res;
    }

    public static class DetailsModEvent
    extends ResourceModalPage.ResourceEvent {
        public DetailsModEvent(AjaxRequestTarget target) {
            super(target);
        }
    }
}

