/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.to.ConnIdObjectClassTO;
import org.apache.syncope.common.to.ConnInstanceTO;
import org.apache.syncope.common.to.MappingItemTO;
import org.apache.syncope.common.to.MappingTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.ConnConfProperty;
import org.apache.syncope.common.types.IntMappingType;
import org.apache.syncope.common.types.MappingPurpose;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.panels.ResourceConnConfPanel;
import org.apache.syncope.console.rest.ConnectorRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MappingPurposePanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceMappingPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    private static final String FIELD_STYLE = "ui-widget-content ui-corner-all short_fixedsize";
    private static final String DEF_FIELD_STYLE = "ui-widget-content ui-corner-all";
    private static final String SHORT_FIELD_STYLE = "ui-widget-content ui-corner-all veryshort_fixedsize";
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private ConnectorRestClient connRestClient;
    private final List<String> schemaNames;
    private final AjaxButton addMappingBtn;
    private final ListView<MappingItemTO> mappings;
    private final ResourceTO resourceTO;
    private final AttributableType attrType;
    private final WebMarkupContainer mappingContainer;
    private final WebMarkupContainer accountLinkContainer;
    private final AjaxCheckBoxPanel accountLinkCheckbox;

    private MappingTO getMapping() {
        MappingTO result = null;
        if (AttributableType.USER == this.attrType) {
            if (this.resourceTO.getUmapping() == null) {
                this.resourceTO.setUmapping(new MappingTO());
            }
            result = this.resourceTO.getUmapping();
        }
        if (AttributableType.ROLE == this.attrType) {
            if (this.resourceTO.getRmapping() == null) {
                this.resourceTO.setRmapping(new MappingTO());
            }
            result = this.resourceTO.getRmapping();
        }
        return result;
    }

    public ResourceMappingPanel(String id, ResourceTO resourceTO, final AttributableType attrType) {
        super(id);
        this.setOutputMarkupId(true);
        this.resourceTO = resourceTO;
        this.attrType = attrType;
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.mappingContainer});
        this.accountLinkContainer = new WebMarkupContainer("accountLinkContainer");
        this.accountLinkContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.accountLinkContainer});
        if (this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L) {
            this.schemaNames = this.getSchemaNames(this.resourceTO.getConnectorId(), this.resourceTO.getConnConfProperties());
            this.setEnabled();
        } else {
            this.schemaNames = Collections.emptyList();
        }
        WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer("jexlHelp");
        AjaxLink<Void> questionMarkJexlHelp = JexlHelpUtil.getAjaxLink(jexlHelp, "questionMarkJexlHelp");
        this.mappingContainer.add(new Component[]{questionMarkJexlHelp});
        questionMarkJexlHelp.add(new Component[]{jexlHelp});
        Label passwordLabel = new Label("passwordLabel", (IModel)new ResourceModel("password"));
        this.mappingContainer.add(new Component[]{passwordLabel});
        if (AttributableType.USER != this.attrType) {
            passwordLabel.setVisible(false);
        }
        Collections.sort(this.getMapping().getItems(), new Comparator<MappingItemTO>(){

            @Override
            public int compare(MappingItemTO left, MappingItemTO right) {
                int compared = left == null && right == null ? 0 : (left == null ? 1 : (right == null ? -1 : (left.getPurpose() == MappingPurpose.BOTH && right.getPurpose() != MappingPurpose.BOTH ? -1 : (left.getPurpose() != MappingPurpose.BOTH && right.getPurpose() == MappingPurpose.BOTH ? 1 : (left.getPurpose() == MappingPurpose.PROPAGATION && (right.getPurpose() == MappingPurpose.SYNCHRONIZATION || right.getPurpose() == MappingPurpose.NONE) ? -1 : (left.getPurpose() == MappingPurpose.SYNCHRONIZATION && right.getPurpose() == MappingPurpose.PROPAGATION ? 1 : (left.getPurpose() == MappingPurpose.SYNCHRONIZATION && right.getPurpose() == MappingPurpose.NONE ? -1 : (left.getPurpose() == MappingPurpose.NONE && right.getPurpose() != MappingPurpose.NONE ? 1 : (left.isAccountid() ? -1 : (right.isAccountid() ? 1 : (left.isPassword() ? -1 : (right.isPassword() ? 1 : left.getIntAttrName().compareTo(right.getIntAttrName())))))))))))));
                return compared;
            }
        });
        this.mappings = new ListView<MappingItemTO>("mappings", this.getMapping().getItems()){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(final ListItem<MappingItemTO> item) {
                final MappingItemTO mapItem = (MappingItemTO)item.getModelObject();
                if (mapItem.getPurpose() == null) {
                    mapItem.setPurpose(MappingPurpose.BOTH);
                }
                AttributableType entity = null;
                if (mapItem.getIntMappingType() != null) {
                    entity = mapItem.getIntMappingType().getAttributableType();
                }
                final ArrayList attrTypes = new ArrayList(ResourceMappingPanel.this.getAttributeTypes(entity));
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){
                    private static final long serialVersionUID = 7170946748485726506L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        int index = -1;
                        for (int i = 0; i < ResourceMappingPanel.this.getMapping().getItems().size() && index == -1; ++i) {
                            if (!mapItem.equals(ResourceMappingPanel.this.getMapping().getItems().get(i))) continue;
                            index = i;
                        }
                        if (index != -1) {
                            ResourceMappingPanel.this.getMapping().getItems().remove(index);
                            item.getParent().removeAll();
                            target.add(new Component[]{ResourceMappingPanel.this});
                        }
                    }

                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        super.updateAjaxAttributes(attributes);
                        AjaxCallListener ajaxCallListener = new AjaxCallListener(){
                            private static final long serialVersionUID = 7160235486520935153L;

                            public CharSequence getPrecondition(Component component) {
                                return "if (!confirm('" + this.getString("confirmDelete") + "')) return false;";
                            }
                        };
                        attributes.getAjaxCallListeners().add(ajaxCallListener);
                    }
                }});
                final AjaxDropDownChoicePanel intAttrNames = new AjaxDropDownChoicePanel("intAttrNames", this.getString("intAttrNames"), new PropertyModel((Object)mapItem, "intAttrName"), false);
                intAttrNames.setChoices(ResourceMappingPanel.this.schemaNames);
                intAttrNames.setRequired(true);
                intAttrNames.setStyleSheet(ResourceMappingPanel.FIELD_STYLE);
                intAttrNames.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                item.add(new Component[]{intAttrNames});
                final AjaxDropDownChoicePanel intMappingTypes = new AjaxDropDownChoicePanel("intMappingTypes", new ResourceModel("intMappingTypes", "intMappingTypes").getObject(), new PropertyModel((Object)mapItem, "intMappingType"));
                intMappingTypes.setRequired(true);
                intMappingTypes.setChoices(attrTypes);
                intMappingTypes.setStyleSheet(ResourceMappingPanel.FIELD_STYLE);
                item.add(new Component[]{intMappingTypes});
                final AjaxDropDownChoicePanel<AttributableType> entitiesPanel = new AjaxDropDownChoicePanel<AttributableType>("entities", new ResourceModel("entities", "entities").getObject(), (IModel<AttributableType>)new Model((Serializable)entity));
                entitiesPanel.setChoices(attrType == AttributableType.ROLE ? Collections.singletonList(AttributableType.ROLE) : Arrays.asList(AttributableType.values()));
                entitiesPanel.setStyleSheet(ResourceMappingPanel.DEF_FIELD_STYLE);
                entitiesPanel.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        attrTypes.clear();
                        attrTypes.addAll(ResourceMappingPanel.this.getAttributeTypes((AttributableType)entitiesPanel.getModelObject()));
                        intMappingTypes.setChoices(attrTypes);
                        intAttrNames.setChoices(Collections.emptyList());
                        target.add(new Component[]{intMappingTypes.getField()});
                        target.add(new Component[]{intAttrNames.getField()});
                    }
                }});
                item.add(new Component[]{entitiesPanel});
                final AjaxTextFieldPanel extAttrNames = new AjaxTextFieldPanel("extAttrName", new ResourceModel("extAttrNames", "extAttrNames").getObject(), (IModel<String>)new PropertyModel((Object)mapItem, "extAttrName"));
                extAttrNames.setChoices(ResourceMappingPanel.this.schemaNames);
                boolean required = false;
                if (mapItem.isPassword()) {
                    extAttrNames.setModelObject((Object)null);
                } else {
                    required = true;
                }
                extAttrNames.setRequired(required);
                extAttrNames.setEnabled(required);
                extAttrNames.setStyleSheet(ResourceMappingPanel.FIELD_STYLE);
                item.add(new Component[]{extAttrNames});
                final AjaxTextFieldPanel mandatory = new AjaxTextFieldPanel("mandatoryCondition", new ResourceModel("mandatoryCondition", "mandatoryCondition").getObject(), (IModel<String>)new PropertyModel((Object)mapItem, "mandatoryCondition"));
                mandatory.setChoices(Arrays.asList("true", "false"));
                mandatory.setStyleSheet(ResourceMappingPanel.SHORT_FIELD_STYLE);
                item.add(new Component[]{mandatory});
                final AjaxCheckBoxPanel accountId = new AjaxCheckBoxPanel("accountId", new ResourceModel("accountId", "accountId").getObject(), (IModel<Boolean>)new PropertyModel((Object)mapItem, "accountid"));
                accountId.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        if (((Boolean)accountId.getModelObject()).booleanValue()) {
                            mapItem.setMandatoryCondition("true");
                            mandatory.setEnabled(false);
                        } else {
                            mapItem.setMandatoryCondition("false");
                            mandatory.setEnabled(true);
                        }
                        target.add(new Component[]{mandatory});
                    }
                }});
                item.add(new Component[]{accountId});
                final AjaxCheckBoxPanel password = new AjaxCheckBoxPanel("password", new ResourceModel("password", "password").getObject(), (IModel<Boolean>)new PropertyModel((Object)mapItem, "password"));
                password.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        extAttrNames.setEnabled(!mapItem.isAccountid() && (Boolean)password.getModelObject() == false);
                        extAttrNames.setModelObject((Object)null);
                        extAttrNames.setRequired((Boolean)password.getModelObject() == false);
                        target.add(new Component[]{extAttrNames});
                        ResourceMappingPanel.this.setAccountId((IntMappingType)intMappingTypes.getModelObject(), accountId, password);
                        target.add(new Component[]{accountId});
                    }
                }});
                item.add(new Component[]{password});
                if (AttributableType.USER != ResourceMappingPanel.this.attrType) {
                    password.setVisible(false);
                }
                WebMarkupContainer purpose = new WebMarkupContainer("purpose");
                purpose.setOutputMarkupId(Boolean.TRUE.booleanValue());
                MappingPurposePanel panel = new MappingPurposePanel("purposeActions", (IModel<MappingPurpose>)new PropertyModel((Object)mapItem, "purpose"), purpose);
                purpose.add(new Component[]{panel});
                item.add(new Component[]{purpose});
                intMappingTypes.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        ResourceMappingPanel.this.setAttrNames((IntMappingType)intMappingTypes.getModelObject(), intAttrNames);
                        target.add(new Component[]{intAttrNames});
                        ResourceMappingPanel.this.setAccountId((IntMappingType)intMappingTypes.getModelObject(), accountId, password);
                        target.add(new Component[]{accountId});
                    }
                }});
                ResourceMappingPanel.this.setAttrNames(mapItem.getIntMappingType(), intAttrNames);
                ResourceMappingPanel.this.setAccountId(mapItem.getIntMappingType(), accountId, password);
            }
        };
        this.mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{this.mappings});
        this.addMappingBtn = new IndicatingAjaxButton("addMappingBtn", (IModel)new ResourceModel("add")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                ResourceMappingPanel.this.getMapping().getItems().add(new MappingItemTO());
                target.add(new Component[]{ResourceMappingPanel.this});
            }
        };
        this.addMappingBtn.setDefaultFormProcessing(false);
        this.addMappingBtn.setEnabled(this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L);
        this.mappingContainer.add(new Component[]{this.addMappingBtn});
        boolean accountLinkEnabled = false;
        if (this.getMapping().getAccountLink() != null) {
            accountLinkEnabled = true;
        }
        this.accountLinkCheckbox = new AjaxCheckBoxPanel("accountLinkCheckbox", new ResourceModel("accountLinkCheckbox", "accountLinkCheckbox").getObject(), (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(accountLinkEnabled)));
        this.accountLinkCheckbox.setEnabled(true);
        this.accountLinkContainer.add(new Component[]{this.accountLinkCheckbox});
        final AjaxTextFieldPanel accountLink = new AjaxTextFieldPanel("accountLink", new ResourceModel("accountLink", "accountLink").getObject(), (IModel<String>)new PropertyModel((Object)this.getMapping(), "accountLink"));
        accountLink.setEnabled(accountLinkEnabled);
        this.accountLinkContainer.add(new Component[]{accountLink});
        this.accountLinkCheckbox.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (((Boolean)ResourceMappingPanel.this.accountLinkCheckbox.getModelObject()).booleanValue()) {
                    accountLink.setEnabled(Boolean.TRUE);
                    accountLink.setModelObject("");
                } else {
                    accountLink.setEnabled(Boolean.FALSE);
                    accountLink.setModelObject("");
                }
                target.add(new Component[]{accountLink});
            }
        }});
    }

    private List<String> getSchemaNames(Long connectorId, Set<ConnConfProperty> conf) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setId(connectorId.longValue());
        connInstanceTO.getConfiguration().addAll(conf);
        return this.connRestClient.getSchemaNames(connInstanceTO);
    }

    private void setEnabled() {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setId(this.resourceTO.getConnectorId().longValue());
        connInstanceTO.getConfiguration().addAll(this.resourceTO.getConnConfProperties());
        List<ConnIdObjectClassTO> objectClasses = this.connRestClient.getSupportedObjectClasses(connInstanceTO);
        boolean enabled = objectClasses.isEmpty() || AttributableType.USER == this.attrType && objectClasses.contains(ConnIdObjectClassTO.ACCOUNT) || AttributableType.ROLE == this.attrType && objectClasses.contains(ConnIdObjectClassTO.GROUP);
        this.mappingContainer.setEnabled(enabled);
        this.mappingContainer.setVisible(enabled);
        this.accountLinkContainer.setEnabled(enabled);
        this.accountLinkContainer.setVisible(enabled);
        if (!enabled) {
            this.getMapping().getItems().clear();
            this.getMapping().setAccountLink(null);
            if (this.accountLinkCheckbox != null) {
                this.accountLinkCheckbox.setModelObject((Object)null);
            }
        }
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof ResourceConnConfPanel.ConnConfModEvent) {
            AjaxRequestTarget target = ((ResourceConnConfPanel.ConnConfModEvent)event.getPayload()).getTarget();
            List<ConnConfProperty> conf = ((ResourceConnConfPanel.ConnConfModEvent)event.getPayload()).getConfiguration();
            this.mappings.removeAll();
            this.addMappingBtn.setEnabled(this.resourceTO.getConnectorId() != null && this.resourceTO.getConnectorId() > 0L);
            this.schemaNames.clear();
            this.schemaNames.addAll(this.getSchemaNames(this.resourceTO.getConnectorId(), new HashSet<ConnConfProperty>(conf)));
            this.setEnabled();
            target.add(new Component[]{this});
        }
    }

    private void setAttrNames(IntMappingType type, AjaxDropDownChoicePanel<String> toBeUpdated) {
        toBeUpdated.setRequired(true);
        toBeUpdated.setEnabled(true);
        if (type == null || type.getAttributableType() == null) {
            toBeUpdated.setChoices(Collections.emptyList());
        } else {
            switch (type) {
                case UserSchema: 
                case RoleSchema: 
                case MembershipSchema: {
                    toBeUpdated.setChoices(this.schemaRestClient.getSchemaNames(type.getAttributableType()));
                    break;
                }
                case UserDerivedSchema: 
                case RoleDerivedSchema: 
                case MembershipDerivedSchema: {
                    toBeUpdated.setChoices(this.schemaRestClient.getDerSchemaNames(type.getAttributableType()));
                    break;
                }
                case UserVirtualSchema: 
                case RoleVirtualSchema: 
                case MembershipVirtualSchema: {
                    toBeUpdated.setChoices(this.schemaRestClient.getVirSchemaNames(type.getAttributableType()));
                    break;
                }
                default: {
                    toBeUpdated.setRequired(false);
                    toBeUpdated.setEnabled(false);
                    toBeUpdated.setChoices(Collections.emptyList());
                }
            }
        }
    }

    private void setAccountId(IntMappingType type, AjaxCheckBoxPanel accountId, AjaxCheckBoxPanel password) {
        if (type != null && type.getAttributableType() != null) {
            switch (type) {
                case UserVirtualSchema: 
                case RoleVirtualSchema: 
                case MembershipVirtualSchema: 
                case Password: {
                    accountId.setReadOnly(true);
                    accountId.setModelObject((Object)false);
                    break;
                }
                default: {
                    if (((Boolean)password.getModelObject()).booleanValue()) {
                        accountId.setReadOnly(true);
                        accountId.setModelObject((Object)false);
                        break;
                    }
                    accountId.setReadOnly(false);
                }
            }
        }
    }

    private List<IntMappingType> getAttributeTypes(AttributableType entity) {
        ArrayList<IntMappingType> res = new ArrayList<IntMappingType>();
        if (entity != null) {
            res.addAll(IntMappingType.getAttributeTypes((AttributableType)AttributableType.valueOf((String)entity.name())));
        }
        return res;
    }
}

