/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.common.to.AbstractPolicyTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.console.rest.PolicyRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourceSecurityPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private PolicyRestClient policyRestClient;
    private IModel<Map<Long, String>> passwordPolicies = null;
    private IModel<Map<Long, String>> accountPolicies = null;
    private IModel<Map<Long, String>> syncPolicies = null;

    public ResourceSecurityPanel(String id, ResourceTO resourceTO) {
        super(id);
        this.setOutputMarkupId(true);
        this.passwordPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.PASSWORD, false)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        this.accountPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.ACCOUNT, false)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        this.syncPolicies = new LoadableDetachableModel<Map<Long, String>>(){
            private static final long serialVersionUID = -2012833443695917883L;

            protected Map<Long, String> load() {
                HashMap<Long, String> res = new HashMap<Long, String>();
                for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.SYNC, false)) {
                    res.put(policyTO.getId(), policyTO.getDescription());
                }
                return res;
            }
        };
        WebMarkupContainer securityContainer = new WebMarkupContainer("security");
        securityContainer.setOutputMarkupId(true);
        this.add(new Component[]{securityContainer});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", new ResourceModel("passwordPolicy", "passwordPolicy").getObject(), new PropertyModel((Object)resourceTO, "passwordPolicy"));
        passwordPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.PASSWORD));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{passwordPolicy});
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", new ResourceModel("accountPolicy", "accountPolicy").getObject(), new PropertyModel((Object)resourceTO, "accountPolicy"));
        accountPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.ACCOUNT));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel syncPolicy = new AjaxDropDownChoicePanel("syncPolicy", new ResourceModel("syncPolicy", "syncPolicy").getObject(), new PropertyModel((Object)resourceTO, "syncPolicy"));
        syncPolicy.setChoiceRenderer((IChoiceRenderer)new PolicyRenderer(PolicyType.SYNC));
        syncPolicy.setChoices(new ArrayList(((Map)this.syncPolicies.getObject()).keySet()));
        ((DropDownChoice)syncPolicy.getField()).setNullValid(true);
        securityContainer.add(new Component[]{syncPolicy});
    }

    private class PolicyRenderer
    extends ChoiceRenderer<Long> {
        private static final long serialVersionUID = 8060500161321947000L;
        private PolicyType type;

        public PolicyRenderer(PolicyType type) {
            this.type = type;
        }

        public Object getDisplayValue(Long object) {
            switch (this.type) {
                case GLOBAL_ACCOUNT: 
                case ACCOUNT: {
                    return ((Map)ResourceSecurityPanel.this.accountPolicies.getObject()).get(object);
                }
                case GLOBAL_PASSWORD: 
                case PASSWORD: {
                    return ((Map)ResourceSecurityPanel.this.passwordPolicies.getObject()).get(object);
                }
                case GLOBAL_SYNC: 
                case SYNC: {
                    return ((Map)ResourceSecurityPanel.this.syncPolicies.getObject()).get(object);
                }
            }
            return "";
        }

        public String getIdValue(Long object, int index) {
            return String.valueOf(object != null ? object : 0L);
        }
    }
}

