/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.ResourceTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.RoleTreeBuilder;
import org.apache.syncope.console.commons.RoleUtils;
import org.apache.syncope.console.commons.SelectChoiceRenderer;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.pages.panels.StatusPanel;
import org.apache.syncope.console.rest.ResourceRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.console.wicket.markup.html.form.NonI18nPalette;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ResourcesPanel
extends Panel {
    private static final long serialVersionUID = -8728071019777410008L;
    @SpringBean
    private ResourceRestClient resourceRestClient;
    @SpringBean
    private RoleTreeBuilder roleTreeBuilder;
    private final AbstractSubjectTO subjectTO;
    private final Set<String> previousResources;
    private final List<String> allResources;

    private ResourcesPanel(Builder builder) {
        super(builder.id);
        this.subjectTO = (AbstractSubjectTO)builder.to;
        this.previousResources = new HashSet<String>(this.subjectTO.getResources());
        this.allResources = new ArrayList<String>();
        for (ResourceTO resourceTO : this.resourceRestClient.getAll()) {
            this.allResources.add(resourceTO.getName());
        }
        Collections.sort(this.allResources);
        AjaxPalettePanel resourcesPalette = null;
        if (this.subjectTO instanceof UserTO) {
            resourcesPalette = new AjaxRecordingPalettePanel("resourcesPalette", new PropertyModel((Object)this.subjectTO, "resources"), new ListModel(this.allResources), builder.statusPanel);
        } else if (this.subjectTO instanceof RoleTO) {
            resourcesPalette = new AjaxPalettePanel("resourcesPalette", new PropertyModel((Object)this.subjectTO, "resources"), new ListModel(this.allResources));
        }
        this.add(new Component[]{resourcesPalette});
    }

    private class AjaxRecordingPalettePanel<T>
    extends AjaxPalettePanel<T> {
        private static final long serialVersionUID = -4215625881756021988L;
        private final StatusPanel statusPanel;

        public AjaxRecordingPalettePanel(String id, IModel<List<T>> model, ListModel<T> choices, StatusPanel statusPanel) {
            super(id, model, choices, new SelectChoiceRenderer(), false, false);
            this.statusPanel = statusPanel;
        }

        @Override
        protected Palette<T> createPalette(IModel<List<T>> model, ListModel<T> choices, IChoiceRenderer<T> renderer, boolean allowOrder, boolean allowMoveAll) {
            return new NonI18nPalette<T>("paletteField", (IModel)model, (IModel)choices, (IChoiceRenderer)renderer, 8, allowOrder, false){
                private static final long serialVersionUID = -3415146226879212841L;

                protected Recorder<T> newRecorderComponent() {
                    Recorder recorder = super.newRecorderComponent();
                    recorder.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                        private static final long serialVersionUID = 5538299138211283825L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            if (ResourcesPanel.this.subjectTO instanceof UserTO) {
                                UserTO userTO = (UserTO)ResourcesPanel.this.subjectTO;
                                HashSet<String> resourcesToRemove = new HashSet<String>(ResourcesPanel.this.previousResources);
                                resourcesToRemove.removeAll(userTO.getResources());
                                if (!resourcesToRemove.isEmpty()) {
                                    HashSet resourcesAssignedViaMembership = new HashSet();
                                    for (MembershipTO membTO : userTO.getMemberships()) {
                                        RoleTO roleTO = RoleUtils.findRole(ResourcesPanel.this.roleTreeBuilder, membTO.getRoleId());
                                        if (roleTO == null) continue;
                                        resourcesAssignedViaMembership.addAll(roleTO.getResources());
                                    }
                                    resourcesToRemove.removeAll(resourcesAssignedViaMembership);
                                }
                                ResourcesPanel.this.previousResources.clear();
                                ResourcesPanel.this.previousResources.addAll(userTO.getResources());
                                StatusUtils.update((AbstractAttributableTO)userTO, AjaxRecordingPalettePanel.this.statusPanel, target, userTO.getResources(), resourcesToRemove);
                            }
                        }
                    }});
                    return recorder;
                }
            };
        }
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 8644108944633025494L;
        private String id;
        private Object to;
        private StatusPanel statusPanel;

        public Builder(String id) {
            this.id = id;
        }

        public Builder attributableTO(Object to) {
            this.to = to;
            return this;
        }

        public Builder statusPanel(StatusPanel statusPanel) {
            this.statusPanel = statusPanel;
            return this;
        }

        public ResourcesPanel build() {
            return new ResourcesPanel(this);
        }
    }
}

