/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.commons.JexlHelpUtil;
import org.apache.syncope.console.pages.RoleSelectModalPage;
import org.apache.syncope.console.pages.UserOwnerSelectModalPage;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleDetailsPanel
extends Panel {
    private static final long serialVersionUID = 855618618337931784L;
    protected static final Logger LOG = LoggerFactory.getLogger(RoleDetailsPanel.class);
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final Fragment parentFragment;
    private final WebMarkupContainer ownerContainer = new WebMarkupContainer("ownerContainer");
    private final OwnerModel userOwnerModel;
    private final OwnerModel roleOwnerModel;
    private ParentModel parentModel;

    public RoleDetailsPanel(String id, RoleTO roleTO, boolean templateMode) {
        super(id);
        this.ownerContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.ownerContainer});
        final ModalWindow userOwnerSelectWin = new ModalWindow("userOwnerSelectWin");
        userOwnerSelectWin.setCssClassName("w_silver");
        userOwnerSelectWin.setCookieName("create-userOwnerSelect-modal");
        this.add(new Component[]{userOwnerSelectWin});
        ModalWindow roleOwnerSelectWin = new ModalWindow("roleOwnerSelectWin");
        roleOwnerSelectWin.setCssClassName("w_silver");
        roleOwnerSelectWin.setCookieName("create-roleOwnerSelect-modal");
        this.add(new Component[]{roleOwnerSelectWin});
        final ModalWindow parentSelectWin = new ModalWindow("parentSelectWin");
        parentSelectWin.setCssClassName("w_silver");
        parentSelectWin.setCookieName("create-parentSelect-modal");
        this.add(new Component[]{parentSelectWin});
        if (templateMode) {
            this.parentFragment = new Fragment("parent", "parentFragment", (MarkupContainer)this);
            this.parentModel = new ParentModel(roleTO);
            final AjaxTextFieldPanel parent = new AjaxTextFieldPanel("parent", "parent", this.parentModel);
            parent.setReadOnly(true);
            parent.setOutputMarkupId(true);
            this.parentFragment.add(new Component[]{parent});
            IndicatingAjaxLink<Void> parentSelect = new IndicatingAjaxLink<Void>("parentSelect"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    parentSelectWin.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            return new RoleSelectModalPage(this.getPage().getPageReference(), parentSelectWin, ParentSelectPayload.class);
                        }
                    });
                    parentSelectWin.show(target);
                }
            };
            this.parentFragment.add(new Component[]{parentSelect});
            IndicatingAjaxLink<Void> parentReset = new IndicatingAjaxLink<Void>("parentReset"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    RoleDetailsPanel.this.parentModel.setObject(null);
                    target.add(new Component[]{parent});
                }
            };
            this.parentFragment.add(new Component[]{parentReset});
        } else {
            this.parentFragment = new Fragment("parent", "emptyFragment", (MarkupContainer)this);
        }
        this.parentFragment.setOutputMarkupId(true);
        this.add(new Component[]{this.parentFragment});
        AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "name", (IModel<String>)new PropertyModel((Object)roleTO, "name"));
        WebMarkupContainer jexlHelp = JexlHelpUtil.getJexlHelpWebContainer("jexlHelp");
        AjaxLink<Void> questionMarkJexlHelp = JexlHelpUtil.getAjaxLink(jexlHelp, "questionMarkJexlHelp");
        this.add(new Component[]{questionMarkJexlHelp});
        questionMarkJexlHelp.add(new Component[]{jexlHelp});
        if (!templateMode) {
            name.addRequiredLabel();
            questionMarkJexlHelp.setVisible(false);
        }
        this.add(new Component[]{name});
        this.userOwnerModel = new OwnerModel(roleTO, AttributableType.USER);
        final AjaxTextFieldPanel userOwner = new AjaxTextFieldPanel("userOwner", "userOwner", this.userOwnerModel);
        userOwner.setReadOnly(true);
        userOwner.setOutputMarkupId(true);
        this.ownerContainer.add(new Component[]{userOwner});
        IndicatingAjaxLink<Void> userOwnerSelect = new IndicatingAjaxLink<Void>("userOwnerSelect"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                userOwnerSelectWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new UserOwnerSelectModalPage(this.getPage().getPageReference(), userOwnerSelectWin);
                    }
                });
                userOwnerSelectWin.show(target);
            }
        };
        this.ownerContainer.add(new Component[]{userOwnerSelect});
        IndicatingAjaxLink<Void> userOwnerReset = new IndicatingAjaxLink<Void>("userOwnerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                RoleDetailsPanel.this.userOwnerModel.setObject(null);
                target.add(new Component[]{userOwner});
            }
        };
        this.ownerContainer.add(new Component[]{userOwnerReset});
        this.roleOwnerModel = new OwnerModel(roleTO, AttributableType.ROLE);
        final AjaxTextFieldPanel roleOwner = new AjaxTextFieldPanel("roleOwner", "roleOwner", this.roleOwnerModel);
        roleOwner.setReadOnly(true);
        roleOwner.setOutputMarkupId(true);
        this.ownerContainer.add(new Component[]{roleOwner});
        IndicatingAjaxLink<Void> roleOwnerSelect = new IndicatingAjaxLink<Void>("roleOwnerSelect"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                parentSelectWin.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new RoleSelectModalPage(this.getPage().getPageReference(), parentSelectWin, RoleOwnerSelectPayload.class);
                    }
                });
                parentSelectWin.show(target);
            }
        };
        this.ownerContainer.add(new Component[]{roleOwnerSelect});
        IndicatingAjaxLink<Void> roleOwnerReset = new IndicatingAjaxLink<Void>("roleOwnerReset"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                RoleDetailsPanel.this.roleOwnerModel.setObject(null);
                target.add(new Component[]{roleOwner});
            }
        };
        this.ownerContainer.add(new Component[]{roleOwnerReset});
        AjaxCheckBoxPanel inhOwner = new AjaxCheckBoxPanel("inheritOwner", "inheritOwner", (IModel<Boolean>)new PropertyModel((Object)roleTO, "inheritOwner"));
        this.add(new Component[]{inhOwner});
        AjaxCheckBoxPanel inhTemplates = new AjaxCheckBoxPanel("inheritTemplates", "inheritTemplates", (IModel<Boolean>)new PropertyModel((Object)roleTO, "inheritTemplates"));
        inhTemplates.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                RoleDetailsPanel.this.send((IEventSink)RoleDetailsPanel.this.getPage(), Broadcast.BREADTH, new AttrTemplatesPanel.RoleAttrTemplatesChange(AttrTemplatesPanel.Type.rAttrTemplates, target));
                RoleDetailsPanel.this.send((IEventSink)RoleDetailsPanel.this.getPage(), Broadcast.BREADTH, new AttrTemplatesPanel.RoleAttrTemplatesChange(AttrTemplatesPanel.Type.rDerAttrTemplates, target));
                RoleDetailsPanel.this.send((IEventSink)RoleDetailsPanel.this.getPage(), Broadcast.BREADTH, new AttrTemplatesPanel.RoleAttrTemplatesChange(AttrTemplatesPanel.Type.rVirAttrTemplates, target));
            }
        }});
        this.add(new Component[]{inhTemplates});
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof ParentSelectPayload) {
            this.parentModel.setObject(((ParentSelectPayload)event.getPayload()).getRoleId());
        }
        if (event.getPayload() instanceof UserOwnerSelectPayload) {
            this.userOwnerModel.setObject(((UserOwnerSelectPayload)event.getPayload()).getUserId());
        }
        if (event.getPayload() instanceof RoleOwnerSelectPayload) {
            this.roleOwnerModel.setObject(((RoleOwnerSelectPayload)event.getPayload()).getRoleId());
        }
        if (event.getPayload() instanceof AjaxRequestTarget) {
            ((AjaxRequestTarget)event.getPayload()).add(new Component[]{this.parentFragment});
            ((AjaxRequestTarget)event.getPayload()).add(new Component[]{this.ownerContainer});
        }
    }

    public static class ParentSelectPayload {
        private final Long roleId;

        public ParentSelectPayload(Long roleId) {
            this.roleId = roleId;
        }

        public Long getRoleId() {
            return this.roleId;
        }
    }

    public static class RoleOwnerSelectPayload {
        private final Long roleId;

        public RoleOwnerSelectPayload(Long roleId) {
            this.roleId = roleId;
        }

        public Long getRoleId() {
            return this.roleId;
        }
    }

    public static class UserOwnerSelectPayload {
        private final Long userId;

        public UserOwnerSelectPayload(Long userId) {
            this.userId = userId;
        }

        public Long getUserId() {
            return this.userId;
        }
    }

    private class ParentModel
    implements IModel {
        private static final long serialVersionUID = 1006546156848990721L;
        private final RoleTO roleTO;

        public ParentModel(RoleTO roleTO) {
            this.roleTO = roleTO;
        }

        public Object getObject() {
            String object = null;
            if (this.roleTO.getParent() != 0L) {
                RoleTO parent = null;
                try {
                    parent = RoleDetailsPanel.this.roleRestClient.read(this.roleTO.getParent());
                }
                catch (Exception e) {
                    LOG.warn("Could not find role with id {}, ignoring", (Object)this.roleTO.getParent(), (Object)e);
                }
                if (parent == null) {
                    this.roleTO.setParent(0L);
                } else {
                    object = parent.getDisplayName();
                }
            }
            return object;
        }

        public void setObject(Object object) {
            this.roleTO.setParent(object instanceof Long ? (Long)object : 0L);
        }

        public void detach() {
        }
    }

    private class OwnerModel
    implements IModel {
        private static final long serialVersionUID = -3865621970810102714L;
        private final RoleTO roleTO;
        private final AttributableType type;

        public OwnerModel(RoleTO roleTO, AttributableType type) {
            this.roleTO = roleTO;
            this.type = type;
        }

        public Object getObject() {
            String object = null;
            switch (this.type) {
                case USER: {
                    if (this.roleTO.getUserOwner() == null) break;
                    UserTO user = null;
                    try {
                        user = RoleDetailsPanel.this.userRestClient.read(this.roleTO.getUserOwner());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not find user with id {}, ignoring", (Object)this.roleTO.getUserOwner(), (Object)e);
                    }
                    if (user == null) {
                        this.roleTO.setUserOwner(null);
                        break;
                    }
                    object = user.getId() + " " + user.getUsername();
                    break;
                }
                case ROLE: {
                    RoleTO role = null;
                    if (this.roleTO.getRoleOwner() == null) break;
                    try {
                        role = RoleDetailsPanel.this.roleRestClient.read(this.roleTO.getRoleOwner());
                    }
                    catch (Exception e) {
                        LOG.warn("Could not find role with id {}, ignoring", (Object)this.roleTO.getRoleOwner(), (Object)e);
                    }
                    if (role == null) {
                        this.roleTO.setRoleOwner(null);
                        break;
                    }
                    object = role.getDisplayName();
                    break;
                }
            }
            return object;
        }

        public void setObject(Object object) {
            switch (this.type) {
                case USER: {
                    this.roleTO.setUserOwner((Long)object);
                    break;
                }
                case ROLE: {
                    this.roleTO.setRoleOwner((Long)object);
                    break;
                }
            }
        }

        public void detach() {
        }
    }
}

