/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.AbstractSysInfoTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.pages.panels.AttributesPanel;
import org.apache.syncope.console.pages.panels.DerivedAttributesPanel;
import org.apache.syncope.console.pages.panels.ResourcesPanel;
import org.apache.syncope.console.pages.panels.RoleDetailsPanel;
import org.apache.syncope.console.pages.panels.RoleSecurityPanel;
import org.apache.syncope.console.pages.panels.StatusPanel;
import org.apache.syncope.console.pages.panels.SysInfoPanel;
import org.apache.syncope.console.pages.panels.VirtualAttributesPanel;
import org.apache.syncope.console.rest.AuthRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RolePanel
extends Panel {
    private static final long serialVersionUID = 4216376097320768369L;
    @SpringBean
    private AuthRestClient authRestClient;
    @SpringBean
    private XMLRolesReader xmlRolesReader;
    private final AjaxPalettePanel<String> entitlements;

    private RolePanel(Builder builder) {
        super(builder.id);
        this.add(new Component[]{new RoleDetailsPanel("details", builder.roleTO, builder.mode == Mode.TEMPLATE)});
        if (builder.pageReference == null || builder.roleTO.getId() == 0L) {
            this.add(new Component[]{new Label("statuspanel", "")});
        } else {
            StatusPanel statusPanel = new StatusPanel("statuspanel", (AbstractSubjectTO)builder.roleTO, new ArrayList<StatusBean>(), builder.pageReference);
            statusPanel.setOutputMarkupId(true);
            MetaDataRoleAuthorizationStrategy.authorize((Component)statusPanel, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Resources", "getConnectorObject"));
            this.add(new Component[]{statusPanel});
        }
        this.add(new Component[]{new SysInfoPanel("systeminformation", (AbstractSysInfoTO)builder.roleTO)});
        AttrTemplatesPanel attrTemplates = new AttrTemplatesPanel("templates", builder.roleTO);
        this.add(new Component[]{attrTemplates});
        this.add(new Component[]{new AttributesPanel("attrs", builder.roleTO, builder.form, builder.mode, attrTemplates)});
        AjaxCheckBoxPanel inhAttributes = new AjaxCheckBoxPanel("inheritAttrs", "inheritAttrs", (IModel<Boolean>)new PropertyModel((Object)builder.roleTO, "inheritAttrs"));
        inhAttributes.setOutputMarkupId(true);
        this.add(new Component[]{inhAttributes});
        this.add(new Component[]{new DerivedAttributesPanel("derAttrs", builder.roleTO, attrTemplates)});
        AjaxCheckBoxPanel inhDerivedAttributes = new AjaxCheckBoxPanel("inheritDerAttrs", "inheritDerAttrs", (IModel<Boolean>)new PropertyModel((Object)builder.roleTO, "inheritDerAttrs"));
        inhDerivedAttributes.setOutputMarkupId(true);
        this.add(new Component[]{inhDerivedAttributes});
        this.add(new Component[]{new VirtualAttributesPanel("virAttrs", builder.roleTO, builder.mode == Mode.TEMPLATE, attrTemplates)});
        AjaxCheckBoxPanel inhVirtualAttributes = new AjaxCheckBoxPanel("inheritVirAttrs", "inheritVirAttrs", (IModel<Boolean>)new PropertyModel((Object)builder.roleTO, "inheritVirAttrs"));
        inhVirtualAttributes.setOutputMarkupId(true);
        this.add(new Component[]{inhVirtualAttributes});
        this.add(new Component[]{new ResourcesPanel.Builder("resources").attributableTO(builder.roleTO).build().setOutputMarkupId(true)});
        ListModel selectedEntitlements = new ListModel(builder.roleTO.getEntitlements());
        List<String> allEntitlements = this.authRestClient.getAllEntitlements();
        if (allEntitlements != null && !allEntitlements.isEmpty()) {
            Collections.sort(allEntitlements);
        }
        ListModel availableEntitlements = new ListModel(allEntitlements);
        this.entitlements = new AjaxPalettePanel("entitlements", selectedEntitlements, availableEntitlements);
        this.add(new Component[]{this.entitlements});
        this.add(new Component[]{new RoleSecurityPanel("security", builder.roleTO).setOutputMarkupId(true)});
    }

    public Collection<String> getSelectedEntitlements() {
        return this.entitlements.getModelCollection();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 8150440254654306070L;
        private String id;
        private Form form;
        private RoleTO roleTO;
        private Mode mode;
        private PageReference pageReference;

        public Builder(String id) {
            this.id = id;
        }

        public Builder form(Form form) {
            this.form = form;
            return this;
        }

        public Builder roleTO(RoleTO roleTO) {
            this.roleTO = roleTO;
            return this;
        }

        public Builder roleModalPageMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder pageRef(PageReference pageReference) {
            this.pageReference = pageReference;
            return this;
        }

        public RolePanel build() {
            return new RolePanel(this);
        }
    }
}

