/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.RoleModalPage;
import org.apache.syncope.console.pages.StatusModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class RoleSearchResultPanel
extends AbstractSearchResultPanel {
    private static final long serialVersionUID = -1180593361914008764L;
    private static final String PAGEID = "Roles";

    public <T extends AbstractAttributableTO> RoleSearchResultPanel(String id, boolean filtered, String fiql, PageReference callerRef, AbstractSubjectRestClient restClient) {
        super(id, filtered, fiql, callerRef, restClient);
        this.initResultTable();
    }

    @Override
    protected List<IColumn<AbstractAttributableTO, String>> getColumns() {
        String[] colnames;
        ArrayList<IColumn<AbstractAttributableTO, String>> columns = new ArrayList<IColumn<AbstractAttributableTO, String>>();
        for (String name : colnames = new String[]{"id", "name", "entitlements"}) {
            columns.add((IColumn<AbstractAttributableTO, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
        columns.add((IColumn<AbstractAttributableTO, String>)new AbstractColumn<AbstractAttributableTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = -3503023501954863131L;

            public String getCssClass() {
                return "action";
            }

            public void populateItem(Item<ICellPopulator<AbstractAttributableTO>> cellItem, String componentId, final IModel<AbstractAttributableTO> model) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, RoleSearchResultPanel.this.page.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        RoleSearchResultPanel.this.statusmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new StatusModalPage(RoleSearchResultPanel.this.page.getPageReference(), RoleSearchResultPanel.this.statusmodal, (AbstractSubjectTO)((RoleTO)model.getObject()));
                            }
                        });
                        RoleSearchResultPanel.this.statusmodal.show(target);
                    }
                }, ActionLink.ActionType.MANAGE_RESOURCES, RoleSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        RoleSearchResultPanel.this.editmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new RoleModalPage(RoleSearchResultPanel.this.page.getPageReference(), RoleSearchResultPanel.this.editmodal, (RoleTO)model.getObject());
                            }
                        });
                        RoleSearchResultPanel.this.editmodal.show(target);
                    }
                }, ActionLink.ActionType.EDIT, RoleSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            final RoleTO roleTO = (RoleTO)RoleSearchResultPanel.this.restClient.delete(((AbstractAttributableTO)model.getObject()).getETagValue(), ((AbstractAttributableTO)model.getObject()).getId());
                            RoleSearchResultPanel.this.page.setModalResult(true);
                            RoleSearchResultPanel.this.editmodal.setPageCreator(new ModalWindow.PageCreator(){
                                private static final long serialVersionUID = -7834632442532690940L;

                                public Page createPage() {
                                    return new ResultStatusModalPage.Builder(RoleSearchResultPanel.this.editmodal, (AbstractSubjectTO)roleTO).build();
                                }
                            });
                            RoleSearchResultPanel.this.editmodal.show(target);
                        }
                        catch (SyncopeClientException scce) {
                            RoleSearchResultPanel.this.error((Serializable)((Object)(RoleSearchResultPanel.this.getString("operation_error") + ": " + scce.getMessage())));
                            RoleSearchResultPanel.this.feedbackPanel.refresh(target);
                        }
                    }
                }, ActionLink.ActionType.DELETE, RoleSearchResultPanel.PAGEID);
                cellItem.add(new Component[]{panel});
            }
        });
        return columns;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        return Collections.singletonList(ActionLink.ActionType.DELETE);
    }

    @Override
    protected String getPageId() {
        return PAGEID;
    }
}

