/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.RoleModalPage;
import org.apache.syncope.console.pages.panels.RoleTabPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleSummaryPanel
extends Panel {
    private static final long serialVersionUID = 643769814985593156L;
    private static final Logger LOG = LoggerFactory.getLogger(RoleSummaryPanel.class);
    @SpringBean
    private XMLRolesReader xmlRolesReader;
    @SpringBean
    private RoleRestClient restClient;
    private RoleTO selectedNode;

    private RoleSummaryPanel(final Builder builder) {
        super(builder.id);
        if (builder.selectedNodeId == null || builder.selectedNodeId == 0L) {
            this.selectedNode = null;
        } else {
            try {
                this.selectedNode = this.restClient.read(builder.selectedNodeId);
            }
            catch (SyncopeClientException e) {
                LOG.error("Could not read {}", (Object)builder.selectedNodeId, (Object)e);
                this.selectedNode = null;
                builder.selectedNodeId = null;
            }
        }
        Fragment fragment = new Fragment("roleSummaryPanel", builder.selectedNodeId == null ? "fakerootFrag" : (builder.selectedNodeId == 0L ? "rootPanel" : "roleViewPanel"), (MarkupContainer)this);
        if (builder.selectedNodeId != null) {
            if (builder.selectedNodeId == 0L) {
                ActionLinksPanel links = new ActionLinksPanel("actionLinks", (IModel<?>)new Model(), builder.callerPageRef);
                links.setOutputMarkupId(true);
                fragment.add(new Component[]{links});
                links.addWithRoles(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        builder.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new RoleModalPage(builder.callerPageRef, builder.window, new RoleTO());
                            }
                        });
                        builder.window.show(target);
                    }
                }, ActionLink.ActionType.CREATE, this.xmlRolesReader.getEntitlement("Roles", "create"));
            } else {
                RoleTabPanel roleTabPanel = new RoleTabPanel("nodeViewPanel", this.selectedNode, builder.window, builder.callerPageRef);
                roleTabPanel.setOutputMarkupId(true);
                fragment.add(new Component[]{roleTabPanel});
            }
        }
        this.add(new Component[]{fragment});
    }

    public RoleTO getSelectedNode() {
        return this.selectedNode;
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 4164563358509351832L;
        private String id;
        private ModalWindow window;
        private PageReference callerPageRef;
        private Long selectedNodeId = null;

        public Builder(String id) {
            this.id = id;
        }

        public Builder window(ModalWindow window) {
            this.window = window;
            return this;
        }

        public Builder callerPageRef(PageReference callerPageRef) {
            this.callerPageRef = callerPageRef;
            return this;
        }

        public Builder selectedNodeId(Long selectedNodeId) {
            this.selectedNodeId = selectedNodeId;
            return this;
        }

        public RoleSummaryPanel build() {
            return new RoleSummaryPanel(this);
        }
    }
}

