/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.console.commons.Mode;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.RoleModalPage;
import org.apache.syncope.console.pages.Roles;
import org.apache.syncope.console.pages.StatusModalPage;
import org.apache.syncope.console.pages.panels.RolePanel;
import org.apache.syncope.console.pages.panels.UserSearchResultPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxButton;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class RoleTabPanel
extends Panel {
    private static final long serialVersionUID = 859236186975983959L;
    @SpringBean
    private XMLRolesReader xmlRolesReader;
    @SpringBean
    private RoleRestClient roleRestClient;
    @SpringBean
    private UserRestClient userRestClient;

    public RoleTabPanel(String id, final RoleTO selectedNode, final ModalWindow window, final PageReference pageRef) {
        super(id);
        this.add(new Component[]{new Label("displayName", selectedNode.getDisplayName())});
        ActionLinksPanel links = new ActionLinksPanel("actionLinks", (IModel<?>)new Model(), pageRef);
        links.setOutputMarkupId(true);
        this.add(new Component[]{links});
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        RoleTO roleTO = new RoleTO();
                        roleTO.setParent(selectedNode.getId());
                        return new RoleModalPage(pageRef, window, roleTO);
                    }
                });
                window.show(target);
            }
        }, ActionLink.ActionType.CREATE, this.xmlRolesReader.getEntitlement("Roles", "create"));
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new StatusModalPage(pageRef, window, (AbstractSubjectTO)RoleTabPanel.this.roleRestClient.read(selectedNode.getId()));
                    }
                });
                window.show(target);
            }
        }, ActionLink.ActionType.MANAGE_RESOURCES, this.xmlRolesReader.getEntitlement("Roles", "update"));
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        RoleTO roleTO = RoleTabPanel.this.roleRestClient.read(selectedNode.getId());
                        return new RoleModalPage(pageRef, window, roleTO);
                    }
                });
                window.show(target);
            }
        }, ActionLink.ActionType.EDIT, this.xmlRolesReader.getEntitlement("Roles", "update"));
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    RoleTabPanel.this.roleRestClient.bulkProvisionMembers(selectedNode.getId());
                    RoleTabPanel.this.info((Serializable)((Object)RoleTabPanel.this.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    RoleTabPanel.this.error((Serializable)((Object)(RoleTabPanel.this.getString("operation_error") + ": " + e.getMessage())));
                }
                ((Roles)pageRef.getPage()).getFeedbackPanel().refresh(target);
            }
        }, ActionLink.ActionType.PROVISION_MEMBERS, this.xmlRolesReader.getEntitlement("Tasks", "execute"));
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    RoleTabPanel.this.roleRestClient.bulkDeprovisionMembers(selectedNode.getId());
                    RoleTabPanel.this.info((Serializable)((Object)RoleTabPanel.this.getString("operation_succeeded")));
                }
                catch (SyncopeClientException e) {
                    RoleTabPanel.this.error((Serializable)((Object)(RoleTabPanel.this.getString("operation_error") + ": " + e.getMessage())));
                }
                ((Roles)pageRef.getPage()).getFeedbackPanel().refresh(target);
            }
        }, ActionLink.ActionType.DEPROVISION_MEMBERS, this.xmlRolesReader.getEntitlement("Tasks", "execute"));
        links.addWithRoles(new ActionLink(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target) {
                try {
                    final RoleTO roleTO = RoleTabPanel.this.roleRestClient.delete(selectedNode.getETagValue(), selectedNode.getId());
                    ((Roles)pageRef.getPage()).setModalResult(true);
                    window.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = -7834632442532690940L;

                        public Page createPage() {
                            return new ResultStatusModalPage.Builder(window, (AbstractSubjectTO)roleTO).build();
                        }
                    });
                    window.show(target);
                }
                catch (SyncopeClientException e) {
                    RoleTabPanel.this.error((Serializable)((Object)(RoleTabPanel.this.getString("operation_error") + ": " + e.getMessage())));
                    ((Roles)pageRef.getPage()).getFeedbackPanel().refresh(target);
                }
            }
        }, ActionLink.ActionType.DELETE, this.xmlRolesReader.getEntitlement("Roles", "delete"));
        Form form = new Form("roleForm");
        form.setModel((IModel)new CompoundPropertyModel((Object)selectedNode));
        form.setOutputMarkupId(true);
        RolePanel rolePanel = new RolePanel.Builder("rolePanel").form(form).roleTO(selectedNode).roleModalPageMode(Mode.ADMIN).build();
        rolePanel.setEnabled(false);
        form.add(new Component[]{rolePanel});
        final WebMarkupContainer userListContainer = new WebMarkupContainer("userListContainer");
        userListContainer.setOutputMarkupId(true);
        userListContainer.setEnabled(true);
        userListContainer.add(new Component[]{new UserSearchResultPanel("userList", true, null, pageRef, this.userRestClient)});
        userListContainer.add(new Component[]{new ClearIndicatingAjaxButton("search", (IModel)new ResourceModel("search"), pageRef){
            private static final long serialVersionUID = -958724007591692537L;

            @Override
            protected void onSubmitInternal(AjaxRequestTarget target, Form<?> form) {
                userListContainer.replace((Component)new UserSearchResultPanel("userList", true, SyncopeClient.getUserSearchConditionBuilder().hasRoles(Long.valueOf(selectedNode.getId()), new Long[0]).query(), pageRef, RoleTabPanel.this.userRestClient));
                target.add(new Component[]{userListContainer});
            }
        }});
        form.add(new Component[]{userListContainer});
        this.add(new Component[]{form});
    }
}

