/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import org.apache.syncope.console.rest.JobRestClient;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Duration;

public class RuntimePanel
extends Panel {
    private static final long serialVersionUID = -9002724127542172464L;
    private boolean latestStatus;
    private Fragment fragmentStop;
    private Fragment fragmentSpinner;
    public AbstractAjaxTimerBehavior timer;
    private final PageReference pageRef;
    private final long jobId;
    private final JobRestClient jobRestClient;

    public RuntimePanel(String componentId, IModel<?> model, PageReference pageRef, long jobId, JobRestClient jobRestClient) {
        super(componentId, model);
        this.pageRef = pageRef;
        this.jobId = jobId;
        this.jobRestClient = jobRestClient;
        this.latestStatus = false;
        this.refresh();
    }

    public final RuntimePanel refresh() {
        boolean currentStatus = this.jobRestClient.isJobRunning(this.jobId);
        if (currentStatus && !this.latestStatus) {
            this.setRunning();
        } else if (!currentStatus) {
            this.setNotRunning();
        }
        this.latestStatus = currentStatus;
        return this;
    }

    public void setRunning() {
        this.fragmentStop = new Fragment("panelStop", "fragmentStop", (MarkupContainer)this);
        this.fragmentStop.addOrReplace(new Component[]{new ClearIndicatingAjaxLink<Void>("stopLink", this.pageRef){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                RuntimePanel.this.jobRestClient.stopJob(RuntimePanel.this.jobId);
                this.setEnabled(false);
                target.add(new Component[]{this});
            }

            public String getAjaxIndicatorMarkupId() {
                return "";
            }
        }});
        this.addOrReplace(new Component[]{this.fragmentStop});
        this.fragmentSpinner = new Fragment("panelSpinner", "fragmentSpinner", (MarkupContainer)this);
        this.addOrReplace(new Component[]{this.fragmentSpinner});
    }

    public void setNotRunning() {
        this.fragmentStop = new Fragment("panelStop", "emptyFragment", (MarkupContainer)this);
        this.addOrReplace(new Component[]{this.fragmentStop});
        this.fragmentSpinner = new Fragment("panelSpinner", "emptyFragment", (MarkupContainer)this);
        this.addOrReplace(new Component[]{this.fragmentSpinner});
    }

    public void setTimer(AbstractAjaxTimerBehavior timer) {
        if (this.timer != null) {
            this.remove(new Behavior[]{this.timer});
        }
        this.timer = timer;
        this.add(new Behavior[]{this.timer});
    }

    public void startPolling(int seconds) {
        AbstractAjaxTimerBehavior timer = new AbstractAjaxTimerBehavior(Duration.seconds((int)seconds)){
            private static final long serialVersionUID = 1L;

            protected void onTimer(AjaxRequestTarget target) {
                target.add(new Component[]{RuntimePanel.this.refresh()});
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getExtraParameters().put("pollingTimeout", "true");
            }
        };
        this.setTimer(timer);
    }
}

