/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.console.pages.SchedTaskModalPage;
import org.apache.syncope.console.pages.Tasks;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.pages.panels.AbstractTasks;
import org.apache.syncope.console.pages.panels.AjaxDataTablePanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.wicket.ajax.markup.html.ClearIndicatingAjaxLink;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.JobColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;

public class SchedTasks
extends AbstractTasks {
    private static final long serialVersionUID = 525486152284253354L;
    public static final String ROLE_MEMBER_PROVISION = "org.apache.syncope.core.quartz.RoleMemberProvisionTaskJob";
    private int paginatorRows;
    private WebMarkupContainer container = new WebMarkupContainer("container");
    private ModalWindow window;
    private AjaxDataTablePanel<AbstractTaskTO, String> table;

    public SchedTasks(String id, final PageReference pageRef) {
        super(id, pageRef);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.window = new ModalWindow("taskWin");
        this.window.setCssClassName("w_silver");
        this.window.setInitialHeight(500);
        this.window.setInitialWidth(700);
        this.window.setCookieName("view-task-win");
        this.add(new Component[]{this.window});
        ((Tasks)pageRef.getPage()).setWindowClosedCallback(this.window, this.container);
        this.paginatorRows = this.prefMan.getPaginatorRows((Request)this.getWebRequest(), "schedtasks.paginator.rows");
        this.table = Tasks.updateTaskTable(this.getColumns(), new Tasks.TasksProvider<SchedTaskTO>(this.restClient, this.paginatorRows, this.getId(), SchedTaskTO.class), this.container, 0, pageRef, this.restClient);
        this.container.add(new Component[]{this.table});
        Form paginatorForm = new Form("PaginatorForm");
        DropDownChoice rowsChooser = new DropDownChoice("rowsChooser", (IModel)new PropertyModel((Object)this, "paginatorRows"), this.prefMan.getPaginatorChoices());
        rowsChooser.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SchedTasks.this.prefMan.set((Request)SchedTasks.this.getWebRequest(), (Response)((WebResponse)SchedTasks.this.getResponse()), "schedtasks.paginator.rows", String.valueOf(SchedTasks.this.paginatorRows));
                SchedTasks.this.table = Tasks.updateTaskTable(SchedTasks.this.getColumns(), new Tasks.TasksProvider<SchedTaskTO>(SchedTasks.this.restClient, SchedTasks.this.paginatorRows, SchedTasks.this.getId(), SchedTaskTO.class), SchedTasks.this.container, SchedTasks.this.table == null ? 0 : (int)SchedTasks.this.table.getCurrentPage(), pageRef, SchedTasks.this.restClient);
                target.add(new Component[]{SchedTasks.this.container});
            }
        }});
        paginatorForm.add(new Component[]{rowsChooser});
        this.add(new Component[]{paginatorForm});
        ClearIndicatingAjaxLink createLink = new ClearIndicatingAjaxLink("createLink", pageRef){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            protected void onClickInternal(AjaxRequestTarget target) {
                SchedTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = -7834632442532690940L;

                    public Page createPage() {
                        return new SchedTaskModalPage(SchedTasks.this.window, new SchedTaskTO(), pageRef);
                    }
                });
                SchedTasks.this.window.show(target);
            }
        };
        MetaDataRoleAuthorizationStrategy.authorize((Component)createLink, (Action)RENDER, (String)this.xmlRolesReader.getEntitlement("Tasks", "create"));
        this.add(new Component[]{createLink});
    }

    private List<IColumn<AbstractTaskTO, String>> getColumns() {
        ArrayList<IColumn<AbstractTaskTO, String>> columns = new ArrayList<IColumn<AbstractTaskTO, String>>();
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, new Object[0]), (Object)"name", "name"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("description", (Component)this, null, new Object[0]), (Object)"description", "description"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("class", (Component)this, null, new Object[0]), (Object)"jobClassName", "jobClassName"));
        columns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this, null, new Object[0]), "lastExec", "lastExec"));
        columns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this, null, new Object[0]), "nextExec", "nextExec"));
        columns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this, null, new Object[0]), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<AbstractTaskTO, String>)new JobColumn((IModel<String>)new StringResourceModel("", (Component)this, null, "", new Object[0]), "runtime", this.pageRef, this.restClient));
        columns.add((IColumn<AbstractTaskTO, String>)new ActionColumn<AbstractTaskTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<AbstractTaskTO> model) {
                final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, SchedTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        SchedTasks.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new SchedTaskModalPage(SchedTasks.this.window, taskTO, SchedTasks.this.pageRef);
                            }
                        });
                        SchedTasks.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.startExecution(taskTO.getId(), false);
                            SchedTasks.this.getSession().info((Serializable)((Object)SchedTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SchedTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        ((NotificationPanel)SchedTasks.this.getPage().get("feedback")).refresh(target);
                        target.add(new Component[]{SchedTasks.this.container});
                    }
                }, ActionLink.ActionType.EXECUTE, "Tasks", !SchedTasks.ROLE_MEMBER_PROVISION.equals(taskTO.getJobClassName()));
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.startExecution(taskTO.getId(), true);
                            SchedTasks.this.getSession().info((Serializable)((Object)SchedTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SchedTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        ((NotificationPanel)SchedTasks.this.getPage().get("feedback")).refresh(target);
                        target.add(new Component[]{SchedTasks.this.container});
                    }
                }, ActionLink.ActionType.DRYRUN, "Tasks", !SchedTasks.ROLE_MEMBER_PROVISION.equals(taskTO.getJobClassName()));
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SchedTasks.this.restClient.delete(taskTO.getId(), SchedTaskTO.class);
                            SchedTasks.this.info((Serializable)((Object)SchedTasks.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SchedTasks.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{SchedTasks.this.container});
                        ((NotificationPanel)SchedTasks.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), SchedTasks.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{SchedTasks.this.table});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        return columns;
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AbstractSearchResultPanel.EventDataWrapper) {
            ((AbstractSearchResultPanel.EventDataWrapper)event.getPayload()).getTarget().add(new Component[]{this.container});
        }
    }
}

