/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.console.pages.panels.SearchClause;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class SearchView
extends ListView<SearchClause> {
    private static final long serialVersionUID = -527351923968737757L;
    private final WebMarkupContainer searchFormContainer;
    private final boolean required;
    private final IModel<List<SearchClause.Type>> types;
    private final IModel<List<String>> anames;
    private final IModel<List<String>> dnames;
    private final IModel<List<String>> roleNames;
    private final IModel<List<String>> resourceNames;
    private final IModel<List<String>> entitlements;

    public SearchView(String id, List<? extends SearchClause> list, WebMarkupContainer searchFormContainer, boolean required, IModel<List<SearchClause.Type>> types, IModel<List<String>> anames, IModel<List<String>> dnames, IModel<List<String>> roleNames, IModel<List<String>> resourceNames, IModel<List<String>> entitlements) {
        super(id, list);
        this.searchFormContainer = searchFormContainer;
        this.required = required;
        this.types = types;
        this.anames = anames;
        this.dnames = dnames;
        this.roleNames = roleNames;
        this.resourceNames = resourceNames;
        this.entitlements = entitlements;
    }

    protected void populateItem(final ListItem<SearchClause> item) {
        SearchClause searchClause = (SearchClause)item.getModelObject();
        DropDownChoice operator = new DropDownChoice("operator", (IModel)new PropertyModel((Object)searchClause, "operator"), Arrays.asList(SearchClause.Operator.values()));
        operator.setOutputMarkupPlaceholderTag(true);
        operator.setNullValid(false);
        operator.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        item.add(new Component[]{operator});
        if (item.getIndex() == 0) {
            operator.setVisible(false);
        }
        final DropDownChoice type = new DropDownChoice("type", (IModel)new PropertyModel((Object)searchClause, "type"), this.types);
        type.setOutputMarkupId(true);
        type.setRequired(this.required);
        type.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{SearchView.this.searchFormContainer});
            }
        }});
        item.add(new Component[]{type});
        DropDownChoice property = new DropDownChoice("property", (IModel)new PropertyModel((Object)searchClause, "property"), (IModel)null);
        property.setOutputMarkupId(true);
        property.setRequired(this.required);
        property.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        item.add(new Component[]{property});
        final TextField value = new TextField("value", (IModel)new PropertyModel((Object)searchClause, "value"));
        value.setOutputMarkupId(true);
        value.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        item.add(new Component[]{value});
        final DropDownChoice comparator = new DropDownChoice("comparator", (IModel)new PropertyModel((Object)searchClause, "comparator"), Collections.emptyList());
        comparator.setOutputMarkupId(true);
        comparator.setNullValid(false);
        comparator.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (type.getModelObject() == SearchClause.Type.ATTRIBUTE) {
                    if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                        value.setModelObject(null);
                        value.setEnabled(false);
                    } else {
                        value.setEnabled(true);
                    }
                    target.add(new Component[]{value});
                }
            }
        }});
        comparator.setRequired(this.required);
        item.add(new Component[]{comparator});
        IndicatingAjaxLink<Void> drop = new IndicatingAjaxLink<Void>("drop"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                ((List)SearchView.this.getModel().getObject()).remove(item.getModelObject());
                target.add(new Component[]{SearchView.this.searchFormContainer});
            }
        };
        item.add(new Component[]{drop});
        if (item.getIndex() == 0) {
            drop.setVisible(false);
            drop.setEnabled(false);
        } else {
            drop.setVisible(true);
            drop.setEnabled(true);
        }
        IndicatingAjaxLink<Void> add = new IndicatingAjaxLink<Void>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                SearchClause clause = new SearchClause();
                ((List)SearchView.this.getModel().getObject()).add(clause);
                target.add(new Component[]{SearchView.this.searchFormContainer});
            }
        };
        item.add(new Component[]{add});
        if (searchClause == null || searchClause.getType() == null) {
            property.setChoices(Collections.emptyList());
        } else {
            switch (searchClause.getType()) {
                case ATTRIBUTE: {
                    ArrayList names = new ArrayList((Collection)this.dnames.getObject());
                    if (this.anames.getObject() != null && !((List)this.anames.getObject()).isEmpty()) {
                        names.addAll((Collection)this.anames.getObject());
                    }
                    Collections.sort(names);
                    property.setChoices(names);
                    comparator.setChoices((IModel)new LoadableDetachableModel<List<SearchClause.Comparator>>(){
                        private static final long serialVersionUID = 5275935387613157437L;

                        protected List<SearchClause.Comparator> load() {
                            return Arrays.asList(SearchClause.Comparator.values());
                        }
                    });
                    comparator.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SearchClause.Comparator>(){
                        private static final long serialVersionUID = -9086043750227867686L;

                        public Object getDisplayValue(SearchClause.Comparator object) {
                            String display;
                            switch (object) {
                                case IS_NULL: {
                                    display = "NULL";
                                    break;
                                }
                                case IS_NOT_NULL: {
                                    display = "NOT NULL";
                                    break;
                                }
                                case EQUALS: {
                                    display = "==";
                                    break;
                                }
                                case NOT_EQUALS: {
                                    display = "!=";
                                    break;
                                }
                                case LESS_THAN: {
                                    display = "<";
                                    break;
                                }
                                case LESS_OR_EQUALS: {
                                    display = "<=";
                                    break;
                                }
                                case GREATER_THAN: {
                                    display = ">";
                                    break;
                                }
                                case GREATER_OR_EQUALS: {
                                    display = ">=";
                                    break;
                                }
                                default: {
                                    display = "";
                                }
                            }
                            return display;
                        }

                        public String getIdValue(SearchClause.Comparator object, int index) {
                            return this.getDisplayValue(object).toString();
                        }
                    });
                    if (!comparator.isEnabled()) {
                        comparator.setEnabled(true);
                        comparator.setRequired(true);
                    }
                    if (value.isEnabled()) break;
                    value.setEnabled(true);
                    break;
                }
                case MEMBERSHIP: {
                    property.setChoices(this.roleNames);
                    property.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -4288397951948436434L;

                        public Object getDisplayValue(String object) {
                            return object;
                        }

                        public String getIdValue(String object, int index) {
                            return object;
                        }
                    });
                    comparator.setChoices((IModel)new LoadableDetachableModel<List<SearchClause.Comparator>>(){
                        private static final long serialVersionUID = 5275935387613157437L;

                        protected List<SearchClause.Comparator> load() {
                            ArrayList<SearchClause.Comparator> comparators = new ArrayList<SearchClause.Comparator>();
                            comparators.add(SearchClause.Comparator.EQUALS);
                            comparators.add(SearchClause.Comparator.NOT_EQUALS);
                            return comparators;
                        }
                    });
                    comparator.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SearchClause.Comparator>(){
                        private static final long serialVersionUID = -9086043750227867686L;

                        public Object getDisplayValue(SearchClause.Comparator object) {
                            String display;
                            switch (object) {
                                case EQUALS: {
                                    display = "IN";
                                    break;
                                }
                                case NOT_EQUALS: {
                                    display = "NOT IN";
                                    break;
                                }
                                default: {
                                    display = "";
                                }
                            }
                            return display;
                        }

                        public String getIdValue(SearchClause.Comparator object, int index) {
                            return this.getDisplayValue(object).toString();
                        }
                    });
                    value.setEnabled(false);
                    value.setModelObject((Object)"");
                    break;
                }
                case RESOURCE: {
                    property.setChoices(this.resourceNames);
                    comparator.setChoices((IModel)new LoadableDetachableModel<List<SearchClause.Comparator>>(){
                        private static final long serialVersionUID = 5275935387613157437L;

                        protected List<SearchClause.Comparator> load() {
                            ArrayList<SearchClause.Comparator> comparators = new ArrayList<SearchClause.Comparator>();
                            comparators.add(SearchClause.Comparator.EQUALS);
                            comparators.add(SearchClause.Comparator.NOT_EQUALS);
                            return comparators;
                        }
                    });
                    comparator.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SearchClause.Comparator>(){
                        private static final long serialVersionUID = -9086043750227867686L;

                        public Object getDisplayValue(SearchClause.Comparator object) {
                            String display;
                            switch (object) {
                                case EQUALS: {
                                    display = "HAS";
                                    break;
                                }
                                case NOT_EQUALS: {
                                    display = "HAS NOT";
                                    break;
                                }
                                default: {
                                    display = "";
                                }
                            }
                            return display;
                        }

                        public String getIdValue(SearchClause.Comparator object, int index) {
                            return this.getDisplayValue(object).toString();
                        }
                    });
                    value.setEnabled(false);
                    value.setModelObject((Object)"");
                    break;
                }
                case ENTITLEMENT: {
                    property.setChoices(this.entitlements);
                    comparator.setChoices((IModel)new LoadableDetachableModel<List<SearchClause.Comparator>>(){
                        private static final long serialVersionUID = 5275935387613157437L;

                        protected List<SearchClause.Comparator> load() {
                            ArrayList<SearchClause.Comparator> comparators = new ArrayList<SearchClause.Comparator>();
                            comparators.add(SearchClause.Comparator.EQUALS);
                            comparators.add(SearchClause.Comparator.NOT_EQUALS);
                            return comparators;
                        }
                    });
                    comparator.setChoiceRenderer((IChoiceRenderer)new IChoiceRenderer<SearchClause.Comparator>(){
                        private static final long serialVersionUID = -9086043750227867686L;

                        public Object getDisplayValue(SearchClause.Comparator object) {
                            String display;
                            switch (object) {
                                case EQUALS: {
                                    display = "HAS";
                                    break;
                                }
                                case NOT_EQUALS: {
                                    display = "HAS NOT";
                                    break;
                                }
                                default: {
                                    display = "";
                                }
                            }
                            return display;
                        }

                        public String getIdValue(SearchClause.Comparator object, int index) {
                            return this.getDisplayValue(object).toString();
                        }
                    });
                    value.setEnabled(false);
                    value.setModelObject((Object)"");
                    break;
                }
                default: {
                    property.setChoices(Collections.emptyList());
                }
            }
        }
    }
}

