/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.mod.StatusMod;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.commons.status.ConnObjectWrapper;
import org.apache.syncope.console.commons.status.Status;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.markup.html.list.AltListView;
import org.apache.syncope.console.pages.ConnObjectModalPage;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.CheckGroupSelector;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusPanel
extends Panel
implements IHeaderContributor {
    private static final Logger LOG = LoggerFactory.getLogger(StatusPanel.class);
    private static final long serialVersionUID = -4064294905566247728L;
    public static final String IMG_STATUES = "../statuses/";
    private static final int CONNOBJECT_WIN_HEIGHT = 400;
    private static final int CONNOBJECT_WIN_WIDTH = 600;
    @SpringBean
    private UserRestClient userRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final ModalWindow connObjectWin = new ModalWindow("connObjectWin");
    private final List<ConnObjectWrapper> connObjects;
    private final Map<String, StatusBean> initialStatusBeanMap;
    private final CheckGroup<StatusBean> checkGroup;
    private final ListView<StatusBean> statusBeansListView;
    private final StatusUtils statusUtils;

    public <T extends AbstractAttributableTO> StatusPanel(String id, final AbstractSubjectTO subject, List<StatusBean> selectedResources, final PageReference pageref) {
        super(id);
        this.connObjectWin.setCssClassName("w_silver");
        this.connObjectWin.setInitialHeight(400);
        this.connObjectWin.setInitialWidth(600);
        this.connObjectWin.setCookieName("connobject-modal");
        this.add(new Component[]{this.connObjectWin});
        this.statusUtils = new StatusUtils(subject instanceof RoleTO ? this.roleRestClient : this.userRestClient);
        this.connObjects = this.statusUtils.getConnectorObjects(subject);
        ArrayList<StatusBean> statusBeans = new ArrayList<StatusBean>(this.connObjects.size() + 1);
        this.initialStatusBeanMap = new LinkedHashMap<String, StatusBean>(this.connObjects.size() + 1);
        StatusBean syncope = new StatusBean((AbstractAttributableTO)subject, "syncope");
        if (subject instanceof UserTO) {
            syncope.setAccountLink(((UserTO)subject).getUsername());
            Object syncopeStatus = Status.UNDEFINED;
            if (((UserTO)subject).getStatus() != null) {
                try {
                    syncopeStatus = Status.valueOf(((UserTO)subject).getStatus().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Unexpected status found: {}", (Object)((UserTO)subject).getStatus(), (Object)e);
                }
            }
            syncope.setStatus((Status)((Object)syncopeStatus));
        } else if (subject instanceof RoleTO) {
            syncope.setAccountLink(((RoleTO)subject).getDisplayName());
            syncope.setStatus(Status.ACTIVE);
        }
        statusBeans.add(syncope);
        this.initialStatusBeanMap.put(syncope.getResourceName(), syncope);
        for (ConnObjectWrapper entry : this.connObjects) {
            StatusBean statusBean = this.statusUtils.getStatusBean(entry.getAttributable(), entry.getResourceName(), entry.getConnObjectTO(), subject instanceof RoleTO);
            this.initialStatusBeanMap.put(entry.getResourceName(), statusBean);
            statusBeans.add(statusBean);
        }
        this.checkGroup = new CheckGroup("group", selectedResources);
        this.checkGroup.setOutputMarkupId(true);
        this.checkGroup.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = -151291731388673682L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.add(new Component[]{this.checkGroup});
        CheckGroupSelector groupSelector = new CheckGroupSelector("groupselector", this.checkGroup);
        if (subject instanceof RoleTO) {
            groupSelector.setVisible(false);
        }
        this.add(new Component[]{groupSelector});
        this.statusBeansListView = new AltListView<StatusBean>("resources", statusBeans){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(ListItem<StatusBean> item) {
                item.add(new Component[]{StatusPanel.this.statusUtils.getStatusImage("icon", ((StatusBean)item.getModelObject()).getStatus())});
                Check check = new Check("check", item.getModel(), StatusPanel.this.checkGroup);
                if (subject instanceof RoleTO) {
                    check.setVisible(false);
                }
                item.add(new Component[]{check});
                item.add(new Component[]{new Label("resource", (IModel)new ResourceModel(((StatusBean)item.getModelObject()).getResourceName(), ((StatusBean)item.getModelObject()).getResourceName()))});
                if (StringUtils.isNotBlank((CharSequence)((StatusBean)item.getModelObject()).getAccountLink())) {
                    item.add(new Component[]{new Label("accountLink", (IModel)new ResourceModel(((StatusBean)item.getModelObject()).getAccountLink(), ((StatusBean)item.getModelObject()).getAccountLink()))});
                } else {
                    item.add(new Component[]{new Label("accountLink", "")});
                }
                final ConnObjectTO connObjectTO = StatusPanel.this.statusUtils.getConnObjectTO(((StatusBean)item.getModelObject()).getAttributableId(), ((StatusBean)item.getModelObject()).getResourceName(), StatusPanel.this.connObjects);
                if (pageref == null || connObjectTO == null) {
                    item.add(new Component[]{new Label("connObject", (IModel)new Model())});
                } else {
                    ActionLinksPanel connObject = new ActionLinksPanel("connObject", (IModel<?>)new Model(), pageref);
                    connObject.add(new ActionLink(){
                        private static final long serialVersionUID = -3722207913631435501L;

                        @Override
                        public void onClick(AjaxRequestTarget target) {
                            StatusPanel.this.connObjectWin.setPageCreator(new ModalWindow.PageCreator(){
                                private static final long serialVersionUID = -7834632442532690940L;

                                public Page createPage() {
                                    return new ConnObjectModalPage(connObjectTO);
                                }
                            });
                            StatusPanel.this.connObjectWin.show(target);
                        }
                    }, ActionLink.ActionType.SEARCH, "Resources", "getConnectorObject");
                    item.add(new Component[]{connObject});
                }
            }
        };
        this.statusBeansListView.setReuseItems(true);
        this.checkGroup.add(new Component[]{this.statusBeansListView});
    }

    public StatusMod getStatusMod() {
        StatusMod result = new StatusMod();
        Collection statusBeans = (Collection)this.checkGroup.getModel().getObject();
        if (statusBeans != null && !statusBeans.isEmpty()) {
            result = StatusUtils.buildStatusMod(statusBeans);
        }
        return result;
    }

    public List<StatusBean> getStatusBeans() {
        return this.statusBeansListView.getModelObject();
    }

    public Map<String, StatusBean> getInitialStatusBeanMap() {
        return this.initialStatusBeanMap;
    }

    public void updateStatusBeans(List<StatusBean> statusBeans) {
        this.statusBeansListView.removeAll();
        this.statusBeansListView.getModelObject().clear();
        this.statusBeansListView.getModelObject().addAll(statusBeans);
        for (StatusBean statusBean : statusBeans) {
            if (((Collection)this.checkGroup.getModelObject()).contains(statusBean) || statusBean.getStatus() != Status.NOT_YET_SUBMITTED) continue;
            ((Collection)this.checkGroup.getModelObject()).add(statusBean);
        }
    }
}

