/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.SyncTaskTO;
import org.apache.syncope.console.pages.RoleTemplateModalPage;
import org.apache.syncope.console.pages.SyncTaskModalPage;
import org.apache.syncope.console.pages.UserTemplateModalPage;
import org.apache.syncope.console.pages.panels.AbstractSyncTasksPanel;
import org.apache.syncope.console.pages.panels.NotificationPanel;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.JobColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class SyncTasksPanel
extends AbstractSyncTasksPanel<SyncTaskTO> {
    private static final long serialVersionUID = 53189199346016099L;

    public SyncTasksPanel(String id, PageReference pageRef) {
        super(id, pageRef, SyncTaskTO.class);
        this.initTasksTable();
    }

    @Override
    protected List<IColumn<AbstractTaskTO, String>> getColumns() {
        ArrayList<IColumn<AbstractTaskTO, String>> syncTaskscolumns = new ArrayList<IColumn<AbstractTaskTO, String>>();
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("id", (Component)this, null, new Object[0]), (Object)"id", "id"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this, null, new Object[0]), (Object)"name", "name"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("description", (Component)this, null, new Object[0]), (Object)"description", "description"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("resourceName", (Component)this, null, new Object[0]), (Object)"resource", "resource"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this, null, new Object[0]), "lastExec", "lastExec"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this, null, new Object[0]), "nextExec", "nextExec"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this, null, new Object[0]), (Object)"latestExecStatus", "latestExecStatus"));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new JobColumn((IModel<String>)new StringResourceModel("", (Component)this, null, "", new Object[0]), "runtime", this.pageRef, this.restClient));
        syncTaskscolumns.add((IColumn<AbstractTaskTO, String>)new ActionColumn<AbstractTaskTO, String>((IModel)new StringResourceModel("actions", (Component)this, null, "", new Object[0])){
            private static final long serialVersionUID = 2054811145491901166L;

            @Override
            public ActionLinksPanel getActions(String componentId, IModel<AbstractTaskTO> model) {
                final SyncTaskTO taskTO = (SyncTaskTO)model.getObject();
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, SyncTasksPanel.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        SyncTasksPanel.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new SyncTaskModalPage(SyncTasksPanel.this.window, taskTO, SyncTasksPanel.this.pageRef);
                            }
                        });
                        SyncTasksPanel.this.window.show(target);
                    }
                }, ActionLink.ActionType.EDIT, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        SyncTasksPanel.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new UserTemplateModalPage(SyncTasksPanel.this.pageRef, SyncTasksPanel.this.window, taskTO);
                            }
                        });
                        SyncTasksPanel.this.window.show(target);
                    }
                }, ActionLink.ActionType.USER_TEMPLATE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        SyncTasksPanel.this.window.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new RoleTemplateModalPage(SyncTasksPanel.this.pageRef, SyncTasksPanel.this.window, taskTO);
                            }
                        });
                        SyncTasksPanel.this.window.show(target);
                    }
                }, ActionLink.ActionType.ROLE_TEMPLATE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SyncTasksPanel.this.restClient.startExecution(taskTO.getId(), false);
                            SyncTasksPanel.this.getSession().info((Serializable)((Object)SyncTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SyncTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{SyncTasksPanel.this.container});
                        ((NotificationPanel)SyncTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.EXECUTE, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SyncTasksPanel.this.restClient.startExecution(taskTO.getId(), true);
                            SyncTasksPanel.this.getSession().info((Serializable)((Object)SyncTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SyncTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{SyncTasksPanel.this.container});
                        ((NotificationPanel)SyncTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DRYRUN, "Tasks");
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            SyncTasksPanel.this.restClient.delete(taskTO.getId(), SyncTaskTO.class);
                            SyncTasksPanel.this.info((Serializable)((Object)SyncTasksPanel.this.getString("operation_succeeded")));
                        }
                        catch (SyncopeClientException scce) {
                            SyncTasksPanel.this.error((Serializable)((Object)scce.getMessage()));
                        }
                        target.add(new Component[]{SyncTasksPanel.this.container});
                        ((NotificationPanel)SyncTasksPanel.this.getPage().get("feedback")).refresh(target);
                    }
                }, ActionLink.ActionType.DELETE, "Tasks");
                return panel;
            }

            @Override
            public Component getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), SyncTasksPanel.this.pageRef);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{SyncTasksPanel.this.table});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, "Tasks", "list");
                return panel;
            }
        });
        return syncTaskscolumns;
    }
}

