/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.common.search.SyncopeFiqlSearchConditionBuilder;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.panels.AbstractSearchPanel;
import org.apache.syncope.console.pages.panels.SearchClause;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class UserSearchPanel
extends AbstractSearchPanel {
    private static final long serialVersionUID = -1769527800450203738L;
    @SpringBean
    private RoleRestClient roleRestClient;

    private UserSearchPanel(Builder builder) {
        super(builder.id, AttributableType.USER, builder.fiql, builder.required);
    }

    @Override
    protected void populate() {
        super.populate();
        this.types = new LoadableDetachableModel<List<SearchClause.Type>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<SearchClause.Type> load() {
                ArrayList<SearchClause.Type> result = new ArrayList<SearchClause.Type>();
                result.add(SearchClause.Type.ATTRIBUTE);
                result.add(SearchClause.Type.MEMBERSHIP);
                result.add(SearchClause.Type.RESOURCE);
                return result;
            }
        };
        this.roleNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                List<RoleTO> roleTOs = UserSearchPanel.this.roleRestClient.list();
                ArrayList<String> result = new ArrayList<String>(roleTOs.size());
                for (RoleTO role : roleTOs) {
                    result.add(role.getDisplayName());
                }
                return result;
            }
        };
    }

    @Override
    protected SyncopeFiqlSearchConditionBuilder getSearchConditionBuilder() {
        return SyncopeClient.getUserSearchConditionBuilder();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = 6308997285778809578L;
        private String id;
        private String fiql = null;
        private boolean required = true;

        public Builder(String id) {
            this.id = id;
        }

        public Builder fiql(String fiql) {
            this.fiql = fiql;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public UserSearchPanel build() {
            return new UserSearchPanel(this);
        }
    }
}

