/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AbstractSubjectTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.console.pages.DisplayAttributesModalPage;
import org.apache.syncope.console.pages.EditUserModalPage;
import org.apache.syncope.console.pages.ResultStatusModalPage;
import org.apache.syncope.console.pages.StatusModalPage;
import org.apache.syncope.console.pages.panels.AbstractSearchResultPanel;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.rest.UserRestClient;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.ActionColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.AttrColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table.TokenColumn;
import org.apache.syncope.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.console.wicket.markup.html.form.ActionLinksPanel;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.springframework.util.ReflectionUtils;

public class UserSearchResultPanel
extends AbstractSearchResultPanel {
    private static final long serialVersionUID = -905187144506842332L;
    private static final String PAGEID = "Users";
    @SpringBean
    private SchemaRestClient schemaRestClient;
    private final List<String> schemaNames;
    private final List<String> dSchemaNames;

    public <T extends AbstractAttributableTO> UserSearchResultPanel(String id, boolean filtered, String fiql, PageReference callerRef, AbstractSubjectRestClient restClient) {
        super(id, filtered, fiql, callerRef, restClient);
        this.schemaNames = this.schemaRestClient.getSchemaNames(AttributableType.USER);
        this.dSchemaNames = this.schemaRestClient.getDerSchemaNames(AttributableType.USER);
        this.initResultTable();
    }

    @Override
    protected List<IColumn<AbstractAttributableTO, String>> getColumns() {
        ArrayList<IColumn<AbstractAttributableTO, String>> columns = new ArrayList<IColumn<AbstractAttributableTO, String>>();
        for (String name : this.prefMan.getList(this.getRequest(), "users.details.view")) {
            Field field = ReflectionUtils.findField(UserTO.class, (String)name);
            if ("token".equalsIgnoreCase(name)) {
                columns.add((IColumn<AbstractAttributableTO, String>)new TokenColumn("token"));
                continue;
            }
            if (field != null && field.getType().equals(Date.class)) {
                columns.add((IColumn<AbstractAttributableTO, String>)new DatePropertyColumn((IModel<String>)new ResourceModel(name, name), name, name));
                continue;
            }
            columns.add((IColumn<AbstractAttributableTO, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
        }
        for (String name : this.prefMan.getList(this.getRequest(), "users.attributes.view")) {
            if (!this.schemaNames.contains(name)) continue;
            columns.add((IColumn<AbstractAttributableTO, String>)new AttrColumn(name, SchemaType.NORMAL));
        }
        for (String name : this.prefMan.getList(this.getRequest(), "users.derived.attributes.view")) {
            if (!this.dSchemaNames.contains(name)) continue;
            columns.add((IColumn<AbstractAttributableTO, String>)new AttrColumn(name, SchemaType.DERIVED));
        }
        if (columns.isEmpty()) {
            for (String name : DisplayAttributesModalPage.DEFAULT_SELECTION) {
                columns.add((IColumn<AbstractAttributableTO, String>)new PropertyColumn((IModel)new ResourceModel(name, name), (Object)name, name));
            }
            this.prefMan.setList(this.getRequest(), this.getResponse(), "users.details.view", Arrays.asList(DisplayAttributesModalPage.DEFAULT_SELECTION));
        }
        columns.add((IColumn<AbstractAttributableTO, String>)new ActionColumn<AbstractAttributableTO, String>((IModel)new ResourceModel("actions", "")){
            private static final long serialVersionUID = -3503023501954863131L;

            @Override
            public ActionLinksPanel getActions(String componentId, final IModel<AbstractAttributableTO> model) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, model, UserSearchResultPanel.this.page.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        UserSearchResultPanel.this.statusmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new StatusModalPage(UserSearchResultPanel.this.page.getPageReference(), UserSearchResultPanel.this.statusmodal, (AbstractSubjectTO)((UserTO)model.getObject()));
                            }
                        });
                        UserSearchResultPanel.this.statusmodal.show(target);
                    }
                }, ActionLink.ActionType.MANAGE_RESOURCES, UserSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        UserSearchResultPanel.this.statusmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new StatusModalPage(UserSearchResultPanel.this.page.getPageReference(), UserSearchResultPanel.this.statusmodal, (AbstractSubjectTO)((UserTO)model.getObject()), true);
                            }
                        });
                        UserSearchResultPanel.this.statusmodal.show(target);
                    }
                }, ActionLink.ActionType.ENABLE, UserSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        UserSearchResultPanel.this.editmodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                UserTO userTO = ((UserRestClient)UserSearchResultPanel.this.restClient).read(((AbstractAttributableTO)model.getObject()).getId());
                                return new EditUserModalPage(UserSearchResultPanel.this.page.getPageReference(), UserSearchResultPanel.this.editmodal, userTO);
                            }
                        });
                        UserSearchResultPanel.this.editmodal.show(target);
                    }
                }, ActionLink.ActionType.EDIT, UserSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        try {
                            final UserTO userTO = (UserTO)UserSearchResultPanel.this.restClient.delete(((AbstractAttributableTO)model.getObject()).getETagValue(), ((AbstractAttributableTO)model.getObject()).getId());
                            UserSearchResultPanel.this.page.setModalResult(true);
                            UserSearchResultPanel.this.editmodal.setPageCreator(new ModalWindow.PageCreator(){
                                private static final long serialVersionUID = -7834632442532690940L;

                                public Page createPage() {
                                    return new ResultStatusModalPage.Builder(UserSearchResultPanel.this.editmodal, (AbstractSubjectTO)userTO).build();
                                }
                            });
                            UserSearchResultPanel.this.editmodal.show(target);
                        }
                        catch (SyncopeClientException scce) {
                            UserSearchResultPanel.this.error((Serializable)((Object)(UserSearchResultPanel.this.getString("operation_error") + ": " + scce.getMessage())));
                            UserSearchResultPanel.this.feedbackPanel.refresh(target);
                        }
                    }
                }, ActionLink.ActionType.DELETE, UserSearchResultPanel.PAGEID);
                return panel;
            }

            public ActionLinksPanel getHeader(String componentId) {
                ActionLinksPanel panel = new ActionLinksPanel(componentId, (IModel<?>)new Model(), UserSearchResultPanel.this.page.getPageReference());
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        UserSearchResultPanel.this.displaymodal.setPageCreator(new ModalWindow.PageCreator(){
                            private static final long serialVersionUID = -7834632442532690940L;

                            public Page createPage() {
                                return new DisplayAttributesModalPage(UserSearchResultPanel.this.page.getPageReference(), UserSearchResultPanel.this.displaymodal, UserSearchResultPanel.this.schemaNames, UserSearchResultPanel.this.dSchemaNames);
                            }
                        });
                        UserSearchResultPanel.this.displaymodal.show(target);
                    }
                }, ActionLink.ActionType.CHANGE_VIEW, UserSearchResultPanel.PAGEID);
                panel.add(new ActionLink(){
                    private static final long serialVersionUID = -7978723352517770644L;

                    @Override
                    public void onClick(AjaxRequestTarget target) {
                        if (target != null) {
                            target.add(new Component[]{UserSearchResultPanel.this.container});
                        }
                    }
                }, ActionLink.ActionType.RELOAD, UserSearchResultPanel.PAGEID, "list");
                return panel;
            }
        });
        return columns;
    }

    @Override
    protected <T extends AbstractAttributableTO> Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.DELETE);
        bulkActions.add(ActionLink.ActionType.SUSPEND);
        bulkActions.add(ActionLink.ActionType.REACTIVATE);
        return bulkActions;
    }

    @Override
    protected String getPageId() {
        return PAGEID;
    }
}

