/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.pages.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.to.MembershipTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.common.to.VirSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.console.pages.panels.AttrTemplatesPanel;
import org.apache.syncope.console.rest.RoleRestClient;
import org.apache.syncope.console.rest.SchemaRestClient;
import org.apache.syncope.console.wicket.markup.html.form.AjaxDecoratedCheckbox;
import org.apache.syncope.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class VirtualAttributesPanel
extends Panel {
    private static final long serialVersionUID = -7982691107029848579L;
    @SpringBean
    private SchemaRestClient schemaRestClient;
    @SpringBean
    private RoleRestClient roleRestClient;
    private final AttrTemplatesPanel attrTemplates;
    private final Map<String, VirSchemaTO> schemas = new TreeMap<String, VirSchemaTO>();

    public <T extends AbstractAttributableTO> VirtualAttributesPanel(String id, T entityTO, boolean templateMode) {
        this(id, entityTO, templateMode, null);
    }

    public <T extends AbstractAttributableTO> VirtualAttributesPanel(String id, final T entityTO, final boolean templateMode, final AttrTemplatesPanel attrTemplates) {
        super(id);
        this.attrTemplates = attrTemplates;
        this.setOutputMarkupId(true);
        LoadableDetachableModel<List<String>> virSchemas = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            private void filter(List<VirSchemaTO> schemaTOs, Set<String> allowed) {
                ListIterator<VirSchemaTO> itor = schemaTOs.listIterator();
                while (itor.hasNext()) {
                    VirSchemaTO schema = itor.next();
                    if (allowed.contains(schema.getName())) continue;
                    itor.remove();
                }
            }

            protected List<String> load() {
                List<VirSchemaTO> schemaTOs;
                if (entityTO instanceof RoleTO) {
                    HashSet<String> allowed;
                    RoleTO roleTO = (RoleTO)entityTO;
                    schemaTOs = VirtualAttributesPanel.this.schemaRestClient.getVirSchemas(AttributableType.ROLE);
                    if (attrTemplates == null) {
                        allowed = new HashSet(roleTO.getRVirAttrTemplates());
                    } else {
                        allowed = new HashSet<String>(attrTemplates.getSelected(AttrTemplatesPanel.Type.rVirAttrTemplates));
                        if (roleTO.isInheritTemplates() && roleTO.getParent() != 0L) {
                            allowed.addAll(VirtualAttributesPanel.this.roleRestClient.read(roleTO.getParent()).getRVirAttrTemplates());
                        }
                    }
                    this.filter(schemaTOs, allowed);
                } else if (entityTO instanceof UserTO) {
                    schemaTOs = VirtualAttributesPanel.this.schemaRestClient.getVirSchemas(AttributableType.USER);
                } else {
                    schemaTOs = VirtualAttributesPanel.this.schemaRestClient.getVirSchemas(AttributableType.MEMBERSHIP);
                    HashSet<String> allowed = new HashSet<String>(VirtualAttributesPanel.this.roleRestClient.read(((MembershipTO)entityTO).getRoleId()).getMVirAttrTemplates());
                    this.filter(schemaTOs, allowed);
                }
                VirtualAttributesPanel.this.schemas.clear();
                for (VirSchemaTO schemaTO : schemaTOs) {
                    VirtualAttributesPanel.this.schemas.put(schemaTO.getName(), schemaTO);
                }
                return new ArrayList<String>(VirtualAttributesPanel.this.schemas.keySet());
            }
        };
        final WebMarkupContainer attributesContainer = new WebMarkupContainer("virAttrContainer");
        attributesContainer.setOutputMarkupId(true);
        this.add(new Component[]{attributesContainer});
        IndicatingAjaxButton addAttributeBtn = new IndicatingAjaxButton("addAttributeBtn", (IModel)new ResourceModel("addAttributeBtn")){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                entityTO.getVirAttrs().add(new AttributeTO());
                target.add(new Component[]{attributesContainer});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{attributesContainer});
            }
        };
        this.add(new Component[]{addAttributeBtn.setDefaultFormProcessing(Boolean.FALSE.booleanValue())});
        ListView<AttributeTO> attributes = new ListView<AttributeTO>("attrs", (IModel)new PropertyModel(entityTO, "virAttrs"), (IModel)virSchemas){
            private static final long serialVersionUID = 9101744072914090143L;
            final /* synthetic */ IModel val$virSchemas;
            {
                this.val$virSchemas = iModel;
                super(x0, x1);
            }

            protected void populateItem(ListItem<AttributeTO> item) {
                MultiFieldPanel<String> multiPanel;
                AjaxTextFieldPanel panel;
                VirSchemaTO attributeSchema;
                final AttributeTO attributeTO = (AttributeTO)item.getModelObject();
                item.add(new Component[]{new AjaxDecoratedCheckbox("toRemove", (IModel)new Model((Serializable)Boolean.FALSE)){
                    private static final long serialVersionUID = 7170946748485726506L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        entityTO.getVirAttrs().remove(attributeTO);
                        target.add(new Component[]{attributesContainer});
                    }

                    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                        super.updateAjaxAttributes(attributes);
                        AjaxCallListener ajaxCallListener = new AjaxCallListener(){
                            private static final long serialVersionUID = 7160235486520935153L;

                            public CharSequence getPrecondition(Component component) {
                                return "if (!confirm('" + this.getString("confirmDelete") + "')) return false;";
                            }
                        };
                        attributes.getAjaxCallListeners().add(ajaxCallListener);
                    }
                }});
                if (attributeTO.getValues().isEmpty()) {
                    attributeTO.getValues().add("");
                }
                if (attributeTO.getSchema() != null && (attributeSchema = (VirSchemaTO)VirtualAttributesPanel.this.schemas.get(attributeTO.getSchema())) != null) {
                    attributeTO.setReadonly(attributeSchema.isReadonly());
                }
                if (templateMode) {
                    panel = new AjaxTextFieldPanel("values", "values", (IModel<String>)new Model());
                    panel.setReadOnly(attributeTO.isReadonly());
                    multiPanel = null;
                } else {
                    panel = new AjaxTextFieldPanel("panel", "values", (IModel<String>)new Model(null));
                    panel.setReadOnly(attributeTO.isReadonly());
                    multiPanel = new MultiFieldPanel<String>("values", (IModel<List<String>>)new PropertyModel((Object)attributeTO, "values"), panel);
                }
                final DropDownChoice schemaChoice = new DropDownChoice("schema", (IModel)new PropertyModel((Object)attributeTO, "schema"), this.val$virSchemas, (IChoiceRenderer)new ChoiceRenderer<String>(){
                    private static final long serialVersionUID = 3109256773218160485L;

                    public Object getDisplayValue(String object) {
                        StringBuilder text = new StringBuilder(object);
                        if (templateMode) {
                            text.append(" (JEXL)");
                        }
                        return text.toString();
                    }
                });
                schemaChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onblur"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        attributeTO.setSchema((String)schemaChoice.getModelObject());
                        VirSchemaTO virSchema = (VirSchemaTO)VirtualAttributesPanel.this.schemas.get(attributeTO.getSchema());
                        if (virSchema != null) {
                            attributeTO.setReadonly(virSchema.isReadonly());
                            panel.setReadOnly(attributeTO.isReadonly());
                        }
                        if (multiPanel != null) {
                            multiPanel.getView().setEnabled(false);
                        }
                    }
                }});
                schemaChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        target.add(new Component[]{attributesContainer});
                    }
                }});
                schemaChoice.setOutputMarkupId(true);
                schemaChoice.setRequired(true);
                item.add(new Component[]{schemaChoice});
                if (templateMode) {
                    item.add(new Component[]{panel});
                } else {
                    item.add(new Component[]{multiPanel});
                }
            }
        };
        attributesContainer.add(new Component[]{attributes});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof AttrTemplatesPanel.RoleAttrTemplatesChange) {
            AttrTemplatesPanel.RoleAttrTemplatesChange update = (AttrTemplatesPanel.RoleAttrTemplatesChange)event.getPayload();
            if (this.attrTemplates != null && update.getType() == AttrTemplatesPanel.Type.rVirAttrTemplates) {
                update.getTarget().add(new Component[]{this});
            }
        }
    }
}

