/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.resources;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemResource
extends AbstractResource {
    private static final long serialVersionUID = -4791087117785935198L;
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemResource.class);
    private final String baseCtx;
    private final String basePath;

    public FilesystemResource(String baseCtx, String basePath) {
        this.baseCtx = baseCtx;
        this.basePath = basePath;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        final File baseDir = new File(this.basePath);
        if (baseDir.exists() && baseDir.canRead() && baseDir.isDirectory()) {
            String reqPath = attributes.getRequest().getUrl().getPath();
            final String subPath = reqPath.substring(reqPath.indexOf(this.baseCtx) + this.baseCtx.length()).replace('/', File.separatorChar);
            LOG.debug("Request for {}", (Object)subPath);
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeData(IResource.Attributes attributes) throws IOException {
                    FileInputStream resourceIS = null;
                    try {
                        resourceIS = new FileInputStream(new File(baseDir, subPath));
                        IOUtils.copy((InputStream)resourceIS, (OutputStream)attributes.getResponse().getOutputStream());
                    }
                    catch (IOException e) {
                        try {
                            LOG.error("Could not read from {}", (Object)(baseDir.getAbsolutePath() + subPath), (Object)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(resourceIS);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((Closeable)resourceIS);
                    }
                    IOUtils.closeQuietly((Closeable)resourceIS);
                }
            });
        } else {
            LOG.error("{} not found, not readable or not a directory", (Object)this.basePath);
        }
        return response;
    }
}

