/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.io.Serializable;
import org.apache.syncope.client.SyncopeClient;
import org.apache.syncope.common.search.OrderByClauseBuilder;
import org.apache.syncope.console.SyncopeSession;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRestClient
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseRestClient.class);
    private static final long serialVersionUID = 1523999867826481989L;

    protected <T> T getAnonymousService(Class<T> serviceClass) {
        return SyncopeSession.get().getAnonymousService(serviceClass);
    }

    protected <T> T getService(Class<T> serviceClass) {
        return SyncopeSession.get().getService(serviceClass);
    }

    protected <T> T getService(String etag, Class<T> serviceClass) {
        return SyncopeSession.get().getService(etag, serviceClass);
    }

    protected <T> void resetClient(Class<T> serviceClass) {
        SyncopeSession.get().resetClient(serviceClass);
    }

    protected String toOrderBy(SortParam<String> sort) {
        OrderByClauseBuilder builder = SyncopeClient.getOrderByClauseBuilder();
        String property = (String)sort.getProperty();
        if (property.indexOf(35) != -1) {
            property = property.substring(property.indexOf(35) + 1);
        }
        if (sort.isAscending()) {
            builder.asc(property);
        } else {
            builder.desc(property);
        }
        return builder.build();
    }
}

