/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.common.services.PolicyService;
import org.apache.syncope.common.to.AbstractPolicyTO;
import org.apache.syncope.common.types.PolicyType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class PolicyRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;

    public <T extends AbstractPolicyTO> T getGlobalPolicy(PolicyType type) {
        AbstractPolicyTO policy = null;
        try {
            policy = this.getService(PolicyService.class).readGlobal(type);
        }
        catch (Exception e) {
            LOG.warn("No global " + type + " policy found", (Throwable)e);
        }
        return (T)policy;
    }

    public <T extends AbstractPolicyTO> T getPolicy(Long id) {
        AbstractPolicyTO policy = null;
        try {
            policy = this.getService(PolicyService.class).read(id);
        }
        catch (Exception e) {
            LOG.warn("No policy found for id {}", (Object)id, (Object)e);
        }
        return (T)policy;
    }

    public <T extends AbstractPolicyTO> List<T> getPolicies(PolicyType type, boolean includeGlobal) {
        ArrayList<T> res = new ArrayList<T>();
        try {
            res.addAll(this.getService(PolicyService.class).list(type));
        }
        catch (Exception ignore) {
            LOG.debug("No policy found", (Throwable)ignore);
        }
        if (includeGlobal) {
            try {
                T globalPolicy = this.getGlobalPolicy(type);
                if (globalPolicy != null) {
                    res.add(0, globalPolicy);
                }
            }
            catch (Exception ignore) {
                LOG.warn("No global policy found", (Throwable)ignore);
            }
        }
        return res;
    }

    public <T extends AbstractPolicyTO> void createPolicy(T policy) {
        this.getService(PolicyService.class).create(policy);
    }

    public <T extends AbstractPolicyTO> void updatePolicy(T policy) {
        this.getService(PolicyService.class).update(Long.valueOf(policy.getId()), policy);
    }

    public void delete(Long id, Class<? extends AbstractPolicyTO> policyClass) {
        this.getService(PolicyService.class).delete(id);
    }

    public List<String> getCorrelationRuleClasses() {
        List rules = null;
        try {
            rules = CollectionWrapper.unwrap((Collection)this.getService(PolicyService.class).getSyncCorrelationRuleClasses());
        }
        catch (Exception e) {
            LOG.error("While getting all correlation rule classes", (Throwable)e);
        }
        return rules;
    }
}

