/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.services.ReportService;
import org.apache.syncope.common.to.ReportExecTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.common.types.JobAction;
import org.apache.syncope.common.types.JobStatusType;
import org.apache.syncope.common.types.ReportExecExportFormat;
import org.apache.syncope.common.wrap.ReportletConfClass;
import org.apache.syncope.console.rest.ExecutionRestClient;
import org.apache.syncope.console.rest.JobRestClient;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Component;

@Component
public class ReportRestClient
extends JobRestClient
implements ExecutionRestClient {
    private static final long serialVersionUID = 1644689667998953604L;

    public List<String> getReportletConfClasses() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List reportletConfClasses = this.getService(ReportService.class).getReportletConfClasses();
            for (ReportletConfClass clazz : reportletConfClasses) {
                result.add((String)clazz.getElement());
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting available reportlet classes", (Throwable)e);
        }
        return result;
    }

    public ReportTO read(Long reportId) {
        return this.getService(ReportService.class).read(reportId);
    }

    public List<ReportTO> list() {
        return this.getService(ReportService.class).list().getResult();
    }

    public List<ReportTO> list(int page, int size, SortParam<String> sort) {
        return this.getService(ReportService.class).list(Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort)).getResult();
    }

    public int count() {
        return this.getService(ReportService.class).list(Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public void create(ReportTO reportTO) {
        this.getService(ReportService.class).create(reportTO);
    }

    public void update(ReportTO reportTO) {
        this.getService(ReportService.class).update(Long.valueOf(reportTO.getId()), reportTO);
    }

    public void delete(Long reportId) {
        this.getService(ReportService.class).delete(reportId);
    }

    @Override
    public void startExecution(long reportId) {
        this.getService(ReportService.class).execute(Long.valueOf(reportId));
    }

    @Override
    public void deleteExecution(long reportExecId) {
        this.getService(ReportService.class).deleteExecution(Long.valueOf(reportExecId));
    }

    public Response exportExecutionResult(Long executionId, ReportExecExportFormat fmt) {
        return this.getService(ReportService.class).exportExecutionResult(executionId, fmt);
    }

    @Override
    public boolean isJobRunning(long reportId) {
        for (ReportExecTO reportExecTO : this.getService(ReportService.class).listJobs(JobStatusType.RUNNING)) {
            if (reportExecTO.getReport() != reportId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startJob(long reportId) {
        this.getService(ReportService.class).actionJob(Long.valueOf(reportId), JobAction.START);
    }

    @Override
    public void stopJob(long reportId) {
        this.getService(ReportService.class).actionJob(Long.valueOf(reportId), JobAction.STOP);
    }
}

