/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.mod.RoleMod;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.ResourceService;
import org.apache.syncope.common.services.RoleService;
import org.apache.syncope.common.to.ConnObjectTO;
import org.apache.syncope.common.to.RoleTO;
import org.apache.syncope.common.types.ResourceAssociationActionType;
import org.apache.syncope.common.types.ResourceDeassociationActionType;
import org.apache.syncope.common.types.SubjectType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.common.wrap.ResourceName;
import org.apache.syncope.console.commons.status.StatusBean;
import org.apache.syncope.console.commons.status.StatusUtils;
import org.apache.syncope.console.rest.AbstractSubjectRestClient;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Component;

@Component
public class RoleRestClient
extends AbstractSubjectRestClient {
    private static final long serialVersionUID = -8549081557283519638L;

    @Override
    public int count() {
        return this.getService(RoleService.class).list(Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public List<RoleTO> list() {
        ArrayList<RoleTO> allRoles = new ArrayList<RoleTO>();
        int count = this.count();
        for (int page = 1; page <= count / 100 + 1; ++page) {
            allRoles.addAll(this.getService(RoleService.class).list(Integer.valueOf(page), Integer.valueOf(100), null, false).getResult());
        }
        return allRoles;
    }

    public List<RoleTO> list(int page, int size, SortParam<String> sort) {
        return this.getService(RoleService.class).list(Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort), false).getResult();
    }

    @Override
    public int searchCount(String fiql) {
        return this.getService(RoleService.class).search(fiql, Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public List<RoleTO> search(String fiql, int page, int size, SortParam<String> sort) {
        return this.getService(RoleService.class).search(fiql, Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort), false).getResult();
    }

    @Override
    public ConnObjectTO getConnectorObject(String resourceName, Long id) {
        return this.getService(ResourceService.class).getConnectorObject(resourceName, SubjectType.ROLE, id);
    }

    public RoleTO create(RoleTO roleTO) {
        Response response = this.getService(RoleService.class).create(roleTO);
        return (RoleTO)response.readEntity(RoleTO.class);
    }

    public RoleTO read(Long id) {
        return this.getAnonymousService(RoleService.class).read(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleTO update(String etag, RoleMod roleMod) {
        RoleTO result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (RoleTO)service.update(Long.valueOf(roleMod.getId()), roleMod).readEntity(RoleTO.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleTO delete(String etag, Long id) {
        RoleTO result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (RoleTO)service.delete(id).readEntity(RoleTO.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }

    public void bulkProvisionMembers(Long id) {
        this.getService(RoleService.class).bulkProvisionMembers(id);
    }

    public void bulkDeprovisionMembers(Long id) {
        this.getService(RoleService.class).bulkDeprovisionMembers(id);
    }

    @Override
    public BulkActionResult bulkAction(BulkAction action) {
        return this.getService(RoleService.class).bulk(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(String etag, long roleId, List<StatusBean> statuses) {
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            service.bulkDeassociation(Long.valueOf(roleId), ResourceDeassociationActionType.UNLINK, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            this.resetClient(RoleService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void link(String etag, long roleId, List<StatusBean> statuses) {
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            service.bulkAssociation(Long.valueOf(roleId), ResourceAssociationActionType.LINK, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class));
            this.resetClient(RoleService.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult deprovision(String etag, long roleId, List<StatusBean> statuses) {
        BulkActionResult result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (BulkActionResult)service.bulkDeassociation(Long.valueOf(roleId), ResourceDeassociationActionType.DEPROVISION, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult provision(String etag, long roleId, List<StatusBean> statuses) {
        BulkActionResult result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (BulkActionResult)service.bulkAssociation(Long.valueOf(roleId), ResourceAssociationActionType.PROVISION, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult unassign(String etag, long roleId, List<StatusBean> statuses) {
        BulkActionResult result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (BulkActionResult)service.bulkDeassociation(Long.valueOf(roleId), ResourceDeassociationActionType.UNASSIGN, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult assign(String etag, long roleId, List<StatusBean> statuses) {
        BulkActionResult result;
        RoleRestClient roleRestClient = this;
        synchronized (roleRestClient) {
            RoleService service = this.getService(etag, RoleService.class);
            result = (BulkActionResult)service.bulkAssociation(Long.valueOf(roleId), ResourceAssociationActionType.ASSIGN, CollectionWrapper.wrap((Collection)StatusUtils.buildStatusMod(statuses).getResourceNames(), ResourceName.class)).readEntity(BulkActionResult.class);
            this.resetClient(RoleService.class);
        }
        return result;
    }
}

