/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.services.ConfigurationService;
import org.apache.syncope.common.services.SchemaService;
import org.apache.syncope.common.to.AbstractSchemaTO;
import org.apache.syncope.common.to.DerSchemaTO;
import org.apache.syncope.common.to.SchemaTO;
import org.apache.syncope.common.to.VirSchemaTO;
import org.apache.syncope.common.types.AttributableType;
import org.apache.syncope.common.types.SchemaType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.commons.AttrLayoutType;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class SchemaRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2479730152700312373L;

    public void filter(List<? extends AbstractSchemaTO> schemaTOs, Collection<String> allowed, boolean exclude) {
        ListIterator<? extends AbstractSchemaTO> itor = schemaTOs.listIterator();
        while (itor.hasNext()) {
            AbstractSchemaTO schema = itor.next();
            if (exclude) {
                if (allowed.contains(schema.getName())) continue;
                itor.remove();
                continue;
            }
            if (!allowed.contains(schema.getName())) continue;
            itor.remove();
        }
    }

    public List<? extends AbstractSchemaTO> getSchemas(AttributableType attrType, SchemaType schemaType) {
        List schemas = Collections.emptyList();
        try {
            schemas = this.getService(SchemaService.class).list(attrType, schemaType);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all schemas for {} and {}", new Object[]{attrType, schemaType, e});
        }
        if (attrType == AttributableType.CONFIGURATION) {
            this.filter(schemas, AttrLayoutType.confKeys(), false);
        }
        return schemas;
    }

    public List<SchemaTO> getSchemas(AttributableType type) {
        List schemas = null;
        try {
            schemas = this.getService(SchemaService.class).list(type, SchemaType.NORMAL);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all schemas", (Throwable)e);
        }
        return schemas;
    }

    public List<String> getSchemaNames(AttributableType attrType, SchemaType schemaType) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try {
            List<? extends AbstractSchemaTO> schemas = this.getSchemas(attrType, schemaType);
            for (AbstractSchemaTO abstractSchemaTO : schemas) {
                schemaNames.add(abstractSchemaTO.getName());
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public List<String> getSchemaNames(AttributableType type) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try {
            List<SchemaTO> schemas = this.getSchemas(type);
            for (SchemaTO schemaTO : schemas) {
                schemaNames.add(schemaTO.getName());
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public List<DerSchemaTO> getDerSchemas(AttributableType type) {
        List userDerSchemas = null;
        try {
            userDerSchemas = this.getService(SchemaService.class).list(type, SchemaType.DERIVED);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user derived schemas", (Throwable)e);
        }
        return userDerSchemas;
    }

    public List<String> getDerSchemaNames(AttributableType type) {
        ArrayList<String> userDerSchemasNames = new ArrayList<String>();
        try {
            List userDerSchemas = this.getService(SchemaService.class).list(type, SchemaType.DERIVED);
            for (DerSchemaTO schemaTO : userDerSchemas) {
                userDerSchemasNames.add(schemaTO.getName());
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all {} derived schema names", (Object)type, (Object)e);
        }
        return userDerSchemasNames;
    }

    public List<VirSchemaTO> getVirSchemas(AttributableType type) {
        List userVirSchemas = null;
        try {
            userVirSchemas = this.getService(SchemaService.class).list(type, SchemaType.VIRTUAL);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all {} virtual schemas", (Object)type, (Object)e);
        }
        return userVirSchemas;
    }

    public List<String> getVirSchemaNames(AttributableType type) {
        ArrayList<String> userVirSchemasNames = new ArrayList<String>();
        try {
            List userVirSchemas = this.getService(SchemaService.class).list(type, SchemaType.VIRTUAL);
            for (VirSchemaTO schemaTO : userVirSchemas) {
                userVirSchemasNames.add(schemaTO.getName());
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user derived schema names", (Throwable)e);
        }
        return userVirSchemasNames;
    }

    public void createSchema(AttributableType type, SchemaTO schemaTO) {
        this.getService(SchemaService.class).create(type, SchemaType.NORMAL, (AbstractSchemaTO)schemaTO);
    }

    public SchemaTO readSchema(AttributableType type, String name) {
        SchemaTO schema = null;
        try {
            schema = (SchemaTO)this.getService(SchemaService.class).read(type, SchemaType.NORMAL, name);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a user schema", (Throwable)e);
        }
        return schema;
    }

    public void updateSchema(AttributableType type, SchemaTO schemaTO) {
        this.getService(SchemaService.class).update(type, SchemaType.NORMAL, schemaTO.getName(), (AbstractSchemaTO)schemaTO);
    }

    public SchemaTO deleteSchema(AttributableType type, String name) {
        SchemaTO response = (SchemaTO)this.getService(SchemaService.class).read(type, SchemaType.NORMAL, name);
        this.getService(SchemaService.class).delete(type, SchemaType.NORMAL, name);
        return response;
    }

    public void createDerSchema(AttributableType type, DerSchemaTO schemaTO) {
        this.getService(SchemaService.class).create(type, SchemaType.DERIVED, (AbstractSchemaTO)schemaTO);
    }

    public DerSchemaTO readDerSchema(AttributableType type, String name) {
        DerSchemaTO derivedSchemaTO = null;
        try {
            derivedSchemaTO = (DerSchemaTO)this.getService(SchemaService.class).read(type, SchemaType.DERIVED, name);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a derived user schema", (Throwable)e);
        }
        return derivedSchemaTO;
    }

    public void updateVirSchema(AttributableType type, VirSchemaTO schemaTO) {
        this.getService(SchemaService.class).update(type, SchemaType.VIRTUAL, schemaTO.getName(), (AbstractSchemaTO)schemaTO);
    }

    public DerSchemaTO deleteDerSchema(AttributableType type, String name) {
        DerSchemaTO schemaTO = (DerSchemaTO)this.getService(SchemaService.class).read(type, SchemaType.DERIVED, name);
        this.getService(SchemaService.class).delete(type, SchemaType.DERIVED, name);
        return schemaTO;
    }

    public void createVirSchema(AttributableType type, VirSchemaTO schemaTO) {
        this.getService(SchemaService.class).create(type, SchemaType.VIRTUAL, (AbstractSchemaTO)schemaTO);
    }

    public void updateDerSchema(AttributableType type, DerSchemaTO schemaTO) {
        this.getService(SchemaService.class).update(type, SchemaType.DERIVED, schemaTO.getName(), (AbstractSchemaTO)schemaTO);
    }

    public VirSchemaTO deleteVirSchema(AttributableType type, String name) {
        VirSchemaTO schemaTO = (VirSchemaTO)this.getService(SchemaService.class).read(type, SchemaType.VIRTUAL, name);
        this.getService(SchemaService.class).delete(type, SchemaType.VIRTUAL, name);
        return schemaTO;
    }

    public List<String> getAllValidatorClasses() {
        List response = null;
        try {
            response = CollectionWrapper.unwrap(new ArrayList(this.getService(ConfigurationService.class).getValidators()));
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all validators", (Throwable)e);
        }
        return response;
    }
}

