/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.reqres.BulkAction;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.syncope.common.services.TaskService;
import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.NotificationTaskTO;
import org.apache.syncope.common.to.PropagationTaskTO;
import org.apache.syncope.common.to.PushTaskTO;
import org.apache.syncope.common.to.SchedTaskTO;
import org.apache.syncope.common.to.SyncTaskTO;
import org.apache.syncope.common.to.TaskExecTO;
import org.apache.syncope.common.types.JobAction;
import org.apache.syncope.common.types.JobStatusType;
import org.apache.syncope.common.types.TaskType;
import org.apache.syncope.common.util.CollectionWrapper;
import org.apache.syncope.console.rest.ExecutionRestClient;
import org.apache.syncope.console.rest.JobRestClient;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.springframework.stereotype.Component;

@Component
public class TaskRestClient
extends JobRestClient
implements ExecutionRestClient {
    private static final long serialVersionUID = 6284485820911028843L;

    public List<String> getJobClasses() {
        ArrayList jobClasses = null;
        try {
            jobClasses = new ArrayList(this.getService(TaskService.class).getJobClasses());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all job classes", (Throwable)e);
        }
        return CollectionWrapper.unwrap(jobClasses);
    }

    public List<String> getSyncActionsClasses() {
        ArrayList actions = null;
        try {
            actions = new ArrayList(this.getService(TaskService.class).getSyncActionsClasses());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all sync actions classes", (Throwable)e);
        }
        return CollectionWrapper.unwrap(actions);
    }

    public List<String> getPushActionsClasses() {
        ArrayList actions = null;
        try {
            actions = new ArrayList(this.getService(TaskService.class).getPushActionsClasses());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all sync actions classes", (Throwable)e);
        }
        return CollectionWrapper.unwrap(actions);
    }

    public int count(String kind) {
        return this.getService(TaskService.class).list(TaskType.fromString((String)kind), Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public int countExecutions(Long taskId) {
        return this.getService(TaskService.class).listExecutions(taskId, Integer.valueOf(1), Integer.valueOf(1)).getTotalCount();
    }

    public <T extends AbstractTaskTO> List<T> list(Class<T> reference, int page, int size, SortParam<String> sort) {
        return this.getService(TaskService.class).list(this.getTaskType(reference), Integer.valueOf(page), Integer.valueOf(size), this.toOrderBy(sort), false).getResult();
    }

    private TaskType getTaskType(Class<?> reference) {
        TaskType result = null;
        if (PropagationTaskTO.class.equals(reference)) {
            result = TaskType.PROPAGATION;
        } else if (NotificationTaskTO.class.equals(reference)) {
            result = TaskType.NOTIFICATION;
        } else if (SchedTaskTO.class.equals(reference)) {
            result = TaskType.SCHEDULED;
        } else if (SyncTaskTO.class.equals(reference)) {
            result = TaskType.SYNCHRONIZATION;
        } else if (PushTaskTO.class.equals(reference)) {
            result = TaskType.PUSH;
        }
        return result;
    }

    public List<TaskExecTO> listExecutions(Long taskId, int page, int size) {
        return this.getService(TaskService.class).listExecutions(taskId, Integer.valueOf(page), Integer.valueOf(size)).getResult();
    }

    public PropagationTaskTO readPropagationTask(Long taskId) {
        return (PropagationTaskTO)this.getService(TaskService.class).read(taskId, false);
    }

    public NotificationTaskTO readNotificationTask(Long taskId) {
        return (NotificationTaskTO)this.getService(TaskService.class).read(taskId, false);
    }

    public <T extends SchedTaskTO> T readSchedTask(Class<T> reference, Long taskId) {
        return (T)((SchedTaskTO)this.getService(TaskService.class).read(taskId, false));
    }

    public void delete(Long taskId, Class<? extends AbstractTaskTO> taskToClass) {
        this.getService(TaskService.class).delete(taskId);
    }

    @Override
    public void startExecution(long taskId) {
        this.startExecution(taskId, false);
    }

    public void startExecution(long taskId, boolean dryRun) {
        this.getService(TaskService.class).execute(Long.valueOf(taskId), dryRun);
    }

    @Override
    public void deleteExecution(long taskExecId) {
        this.getService(TaskService.class).deleteExecution(Long.valueOf(taskExecId));
    }

    public void createSyncTask(SyncTaskTO taskTO) {
        this.getService(TaskService.class).create((SchedTaskTO)taskTO);
    }

    public void createSchedTask(SchedTaskTO taskTO) {
        this.getService(TaskService.class).create(taskTO);
    }

    public void updateSchedTask(SchedTaskTO taskTO) {
        this.getService(TaskService.class).update(Long.valueOf(taskTO.getId()), (AbstractTaskTO)taskTO);
    }

    public void updateSyncTask(SyncTaskTO taskTO) {
        this.getService(TaskService.class).update(Long.valueOf(taskTO.getId()), (AbstractTaskTO)taskTO);
    }

    public BulkActionResult bulkAction(BulkAction action) {
        return this.getService(TaskService.class).bulk(action);
    }

    @Override
    public boolean isJobRunning(long taskId) {
        for (TaskExecTO taskExecTO : this.getService(TaskService.class).listJobs(JobStatusType.RUNNING)) {
            if (taskExecTO.getTask() != taskId) continue;
            return true;
        }
        return false;
    }

    @Override
    public void startJob(long taskId) {
        this.getService(TaskService.class).actionJob(Long.valueOf(taskId), JobAction.START);
    }

    @Override
    public void stopJob(long taskId) {
        this.getService(TaskService.class).actionJob(Long.valueOf(taskId), JobAction.STOP);
    }
}

