/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.rest;

import org.apache.syncope.common.SyncopeClientException;
import org.apache.syncope.common.mod.UserMod;
import org.apache.syncope.common.services.UserSelfService;
import org.apache.syncope.common.to.UserTO;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.rest.BaseRestClient;
import org.springframework.stereotype.Component;

@Component
public class UserSelfRestClient
extends BaseRestClient {
    private static final long serialVersionUID = 2994691796924731295L;

    public boolean isSelfRegistrationAllowed() {
        Boolean result = null;
        try {
            result = SyncopeSession.get().isSelfRegAllowed();
        }
        catch (SyncopeClientException e) {
            LOG.error("While seeking if self registration is allowed", (Throwable)e);
        }
        return result == null ? false : result;
    }

    public UserTO read() {
        return this.getService(UserSelfService.class).read();
    }

    public void create(UserTO userTO, boolean storePassword) {
        this.getService(UserSelfService.class).create(userTO, storePassword);
    }

    public void update(UserMod userMod) {
        this.getService(UserSelfService.class).update(Long.valueOf(userMod.getId()), userMod);
    }

    public void delete() {
        this.getService(UserSelfService.class).delete();
    }

    public boolean isPasswordResetAllowed() {
        Boolean result = null;
        try {
            result = SyncopeSession.get().isPwdResetAllowed();
        }
        catch (SyncopeClientException e) {
            LOG.error("While seeking if password reset is allowed", (Throwable)e);
        }
        return result == null ? false : result;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        Boolean result = null;
        try {
            result = SyncopeSession.get().isPwdResetRequiringSecurityQuestions();
        }
        catch (SyncopeClientException e) {
            LOG.error("While seeking if password reset requires security question", (Throwable)e);
        }
        return result == null ? false : result;
    }

    public void requestPasswordReset(String username, String securityAnswer) {
        this.getService(UserSelfService.class).requestPasswordReset(username, securityAnswer);
    }

    public void confirmPasswordReset(String token, String password) {
        this.getService(UserSelfService.class).confirmPasswordReset(token, password);
    }
}

