/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import org.apache.syncope.common.reqres.BulkActionResult;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ActionResultColumn<T, S>
extends AbstractColumn<T, S> {
    private static final long serialVersionUID = 7955560320949560716L;
    private static final Logger LOG = LoggerFactory.getLogger(ActionResultColumn.class);
    private final BulkActionResult results;
    private final String idFieldName;

    public ActionResultColumn(BulkActionResult results, String idFieldName) {
        super((IModel)new Model());
        this.results = results;
        this.idFieldName = idFieldName;
    }

    public String getCssClass() {
        return "bulkResultColumn";
    }

    public Component getHeader(String componentId) {
        return new Label(componentId, (IModel)new ResourceModel("bulkActionResultLabel", "Result"));
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        try {
            PropertyDescriptor propDesc = BeanUtils.getPropertyDescriptor(rowModel.getObject().getClass(), (String)this.idFieldName);
            Object id = propDesc.getReadMethod().invoke(rowModel.getObject(), new Object[0]);
            BulkActionResult.Status status = id == null ? null : (BulkActionResult.Status)this.results.getResultMap().get(id.toString());
            item.add(new Component[]{new Label(componentId, (Serializable)(status == null ? BulkActionResult.Status.SUCCESS : status.toString()))});
        }
        catch (Exception e) {
            LOG.error("Errore retrieving target id value", (Throwable)e);
        }
    }
}

