/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table;

import java.util.List;
import org.apache.syncope.common.to.AbstractAttributableTO;
import org.apache.syncope.common.to.AttributeTO;
import org.apache.syncope.common.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class AttrColumn
extends AbstractColumn<AbstractAttributableTO, String> {
    private static final long serialVersionUID = 2624734332447371372L;
    private final String name;
    private final SchemaType schemaType;

    public AttrColumn(String name, SchemaType schemaType) {
        super((IModel)new ResourceModel(name, name), (Object)(schemaType.name() + "#" + name));
        this.name = name;
        this.schemaType = schemaType;
    }

    public void populateItem(Item<ICellPopulator<AbstractAttributableTO>> cellItem, String componentId, IModel<AbstractAttributableTO> rowModel) {
        List values = null;
        switch (this.schemaType) {
            case NORMAL: {
                if (!((AbstractAttributableTO)rowModel.getObject()).getAttrMap().containsKey(this.name)) break;
                values = ((AttributeTO)((AbstractAttributableTO)rowModel.getObject()).getAttrMap().get(this.name)).getValues();
                break;
            }
            case VIRTUAL: {
                if (!((AbstractAttributableTO)rowModel.getObject()).getVirAttrMap().containsKey(this.name)) break;
                values = ((AttributeTO)((AbstractAttributableTO)rowModel.getObject()).getVirAttrMap().get(this.name)).getValues();
                break;
            }
            case DERIVED: {
                if (!((AbstractAttributableTO)rowModel.getObject()).getDerAttrMap().containsKey(this.name)) break;
                values = ((AttributeTO)((AbstractAttributableTO)rowModel.getObject()).getDerAttrMap().get(this.name)).getValues();
                break;
            }
        }
        if (values == null || values.isEmpty()) {
            cellItem.add(new Component[]{new Label(componentId, "")});
        } else if (values.size() == 1) {
            cellItem.add(new Component[]{new Label(componentId, (String)values.get(0))});
        } else {
            cellItem.add(new Component[]{new Label(componentId, values.toString())});
        }
    }
}

