/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.extensions.markup.html.repeater.data.table;

import org.apache.syncope.common.to.AbstractTaskTO;
import org.apache.syncope.common.to.ReportTO;
import org.apache.syncope.console.pages.panels.RuntimePanel;
import org.apache.syncope.console.rest.JobRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobColumn<T, S>
extends AbstractColumn<T, S> {
    private static final long serialVersionUID = 7955560320949560725L;
    protected static final Logger LOG = LoggerFactory.getLogger(JobColumn.class);
    private final PageReference pageRef;
    private RuntimePanel panel;
    private final JobRestClient jobRestClient;

    public JobColumn(IModel<String> displayModel, S sortProperty, PageReference pageRef, JobRestClient jobRestClient) {
        super(displayModel, sortProperty);
        this.pageRef = pageRef;
        this.jobRestClient = jobRestClient;
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> model) {
        Long jobId = null;
        if (model.getObject() instanceof AbstractTaskTO) {
            jobId = ((AbstractTaskTO)model.getObject()).getId();
        } else if (model.getObject() instanceof ReportTO) {
            jobId = ((ReportTO)model.getObject()).getId();
        }
        if (jobId != null) {
            this.panel = new RuntimePanel(componentId, model, this.pageRef, jobId, this.jobRestClient);
            this.panel.startPolling(10);
            item.add(new Component[]{this.panel});
        }
    }
}

