/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AjaxDoubleFieldPanel
extends FieldPanel<Double> {
    private static final long serialVersionUID = 935151916638207380L;
    private static final Pattern ENGLISH_DOUBLE_PATTERN = Pattern.compile("\\d+\\.\\d+");
    private static final Pattern OTHER_DOUBLE_PATTERN = Pattern.compile("\\d+,\\d+");
    private final String name;
    private final Pattern pattern;
    private final DecimalFormat englishDf;
    private final DecimalFormat localeDf;

    public AjaxDoubleFieldPanel(String id, final String name, String conversionPattern, IModel<Double> model) {
        super(id, model);
        this.name = name;
        this.pattern = SyncopeSession.get().getLocale().equals(Locale.ENGLISH) ? ENGLISH_DOUBLE_PATTERN : OTHER_DOUBLE_PATTERN;
        this.englishDf = new DecimalFormat();
        this.englishDf.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        if (StringUtils.isNotBlank((CharSequence)conversionPattern)) {
            this.englishDf.applyPattern(conversionPattern);
        }
        this.localeDf = new DecimalFormat();
        this.localeDf.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(SyncopeSession.get().getLocale()));
        if (StringUtils.isNotBlank((CharSequence)conversionPattern)) {
            this.localeDf.applyPattern(conversionPattern);
        }
        this.field = new TextField<Double>("doubleField", model){
            private static final long serialVersionUID = -378877047108711669L;

            protected void convertInput() {
                if (StringUtils.isNotBlank((CharSequence)this.getInput())) {
                    if (AjaxDoubleFieldPanel.this.pattern.matcher(this.getInput()).matches()) {
                        try {
                            Double value = AjaxDoubleFieldPanel.this.localeDf.parse(this.getInput()).doubleValue();
                            this.setConvertedInput(value);
                        }
                        catch (ParseException e) {
                            this.error((Serializable)((Object)(name + ": " + this.getString("textField.DoubleValidator"))));
                        }
                    } else {
                        this.error((Serializable)((Object)(name + ": " + this.getString("textField.DoubleValidator"))));
                    }
                }
            }
        };
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
        if (!this.isReadOnly()) {
            this.field.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
    }

    @Override
    public FieldPanel<Double> addRequiredLabel() {
        if (!this.isRequired()) {
            this.setRequired(true);
        }
        this.isRequiredLabelAdded = true;
        return this;
    }

    @Override
    public FieldPanel<Double> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<Double>(){
            private static final long serialVersionUID = 527651414610325237L;

            public Double getObject() {
                Double value = null;
                if (list != null && !list.isEmpty() && StringUtils.isNotEmpty((CharSequence)((Serializable)list.get(0)).toString())) {
                    try {
                        value = AjaxDoubleFieldPanel.this.englishDf.parse(((Serializable)list.get(0)).toString()).doubleValue();
                    }
                    catch (ParseException e) {
                        AjaxDoubleFieldPanel.this.error((Serializable)((Object)(AjaxDoubleFieldPanel.this.name + ": " + AjaxDoubleFieldPanel.this.getString("textField.DoubleValidator"))));
                    }
                }
                return value;
            }

            public void setObject(Double object) {
                list.clear();
                if (object != null) {
                    list.add(AjaxDoubleFieldPanel.this.englishDf.format(object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel<Double> setNewModel(final ListItem item) {
        Model<Double> model = new Model<Double>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Double getObject() {
                Double value = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            value = AjaxDoubleFieldPanel.this.englishDf.parse(obj.toString()).doubleValue();
                        }
                        catch (ParseException e) {
                            AjaxDoubleFieldPanel.this.error((Serializable)((Object)(AjaxDoubleFieldPanel.this.name + ": " + AjaxDoubleFieldPanel.this.getString("textField.DoubleValidator"))));
                        }
                    } else if (obj instanceof Double) {
                        value = (Double)obj;
                    }
                }
                return value;
            }

            public void setObject(Double object) {
                item.setModelObject((Object)AjaxDoubleFieldPanel.this.englishDf.format(object));
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }
}

