/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;

public class AjaxTextFieldPanel
extends FieldPanel<String>
implements Cloneable {
    private static final long serialVersionUID = 238940918106696068L;
    private List<String> choices = Collections.emptyList();

    public AjaxTextFieldPanel(String id, String name, IModel<String> model) {
        super(id, model);
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(true);
        settings.setShowListOnEmptyInput(true);
        this.field = new AutoCompleteTextField<String>("textField", model, settings){
            private static final long serialVersionUID = -6648767303091874219L;

            protected Iterator<String> getChoices(String input) {
                Pattern pattern = Pattern.compile(".*" + Pattern.quote(input) + ".*", 2);
                ArrayList<String> result = new ArrayList<String>();
                for (String choice : AjaxTextFieldPanel.this.choices) {
                    if (!pattern.matcher(choice).matches()) continue;
                    result.add(choice);
                }
                return result.iterator();
            }
        };
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
        if (!this.isReadOnly()) {
            this.field.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
    }

    public void addValidator(IValidator<? super String> validator) {
        this.field.add(validator);
    }

    public void setChoices(List<String> choices) {
        if (choices != null) {
            this.choices = choices;
        }
    }

    @Override
    public FieldPanel<String> clone() {
        AjaxTextFieldPanel panel = (AjaxTextFieldPanel)super.clone();
        panel.setChoices(this.choices);
        return panel;
    }
}

