/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.console.commons.HttpResourceStream;
import org.apache.syncope.console.pages.BaseModalPage;
import org.apache.syncope.console.preview.PreviewUtil;
import org.apache.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.crypt.Base64;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.IResourceStream;

public class BinaryFieldPanel
extends FieldPanel<String> {
    private static final long serialVersionUID = 6264462604183088931L;
    private final String mimeType;
    private final WebMarkupContainer container;
    private final Link<Void> downloadLink;
    private final Form<?> uploadForm;
    private final Fragment emptyFragment;
    @SpringBean
    private PreviewUtil previewUtil;

    public BinaryFieldPanel(String id, final String name, IModel<String> model, final String mimeType) {
        super(id, model);
        this.mimeType = mimeType;
        this.uploadForm = new StatelessForm("uploadForm");
        this.uploadForm.setMultiPart(true);
        this.uploadForm.setMaxSize(Bytes.megabytes((long)4L));
        this.add(new Component[]{this.uploadForm});
        this.container = new WebMarkupContainer("previewContainer");
        this.container.setOutputMarkupId(true);
        this.emptyFragment = new Fragment("panelPreview", "emptyFragment", (MarkupContainer)this.container);
        this.emptyFragment.setOutputMarkupId(true);
        this.container.add(new Component[]{this.emptyFragment});
        this.uploadForm.add(new Component[]{this.container});
        this.field = new TextField("textField", model);
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
        this.uploadForm.add(new Component[]{new Label("preview", StringUtils.isBlank((CharSequence)mimeType) ? "" : "(" + mimeType + ")")});
        this.downloadLink = new Link<Void>("downloadLink"){
            private static final long serialVersionUID = -4331619903296515985L;

            public void onClick() {
                try {
                    HttpResourceStream stream = new HttpResourceStream(BinaryFieldPanel.this.buildResponse());
                    ResourceStreamRequestHandler rsrh = new ResourceStreamRequestHandler((IResourceStream)stream);
                    rsrh.setFileName(stream.getFilename() == null ? name : stream.getFilename());
                    rsrh.setContentDisposition(ContentDisposition.ATTACHMENT);
                    this.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)rsrh);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)(this.getString("error") + ": " + e.getMessage())));
                }
            }
        };
        this.downloadLink.setOutputMarkupId(true);
        this.uploadForm.add(new Component[]{this.downloadLink});
        final FileUploadField fileUpload = new FileUploadField("fileUpload", (IModel)new Model());
        fileUpload.setOutputMarkupId(true);
        fileUpload.add(new Behavior[]{new AjaxFormSubmitBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onSubmit(AjaxRequestTarget target) {
                FileUpload uploadedFile = fileUpload.getFileUpload();
                if (uploadedFile != null) {
                    try {
                        byte[] uploadedBytes = uploadedFile.getBytes();
                        String uploaded = new String(Base64.encodeBase64((byte[])uploadedBytes), "UTF-8");
                        BinaryFieldPanel.this.field.setModelObject((Object)uploaded);
                        target.add(new Component[]{BinaryFieldPanel.this.field});
                        Component panelPreview = BinaryFieldPanel.this.previewUtil.getPreviewer(mimeType, uploadedBytes);
                        if (panelPreview != null) {
                            BinaryFieldPanel.this.changePreviewer(panelPreview);
                        }
                        fileUpload.setModelObject(null);
                        BinaryFieldPanel.this.uploadForm.addOrReplace(new Component[]{fileUpload});
                        BinaryFieldPanel.this.downloadLink.setEnabled(StringUtils.isNotBlank((CharSequence)uploaded));
                        target.add(new Component[]{BinaryFieldPanel.this.uploadForm});
                    }
                    catch (Exception e) {
                        BinaryFieldPanel.this.error((Serializable)((Object)(BinaryFieldPanel.this.getString("error") + ": " + e.getMessage())));
                        ((BaseModalPage)BinaryFieldPanel.this.getPage()).getFeedbackPanel().refresh(target);
                        AbstractFieldPanel.LOG.error("While saving uploaded file", (Throwable)e);
                    }
                }
            }
        }});
        this.uploadForm.add(new Component[]{fileUpload});
        IndicatingAjaxLink<Void> uploadLink = new IndicatingAjaxLink<Void>("uploadLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
            }
        };
        this.uploadForm.add(new Component[]{uploadLink});
        IndicatingAjaxLink<Void> resetLink = new IndicatingAjaxLink<Void>("resetLink"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                BinaryFieldPanel.this.field.setModelObject(null);
                target.add(new Component[]{BinaryFieldPanel.this.field});
                BinaryFieldPanel.this.downloadLink.setEnabled(false);
                BinaryFieldPanel.this.container.addOrReplace(new Component[]{BinaryFieldPanel.this.emptyFragment});
                BinaryFieldPanel.this.uploadForm.addOrReplace(new Component[]{BinaryFieldPanel.this.container});
                target.add(new Component[]{BinaryFieldPanel.this.uploadForm});
            }
        };
        this.uploadForm.add(new Component[]{resetLink});
    }

    private Response buildResponse() {
        return Response.ok((Object)new ByteArrayInputStream(Base64.decodeBase64((String)((String)this.getModelObject())))).type(StringUtils.isBlank((CharSequence)this.mimeType) ? "application/octet-stream" : this.mimeType).build();
    }

    private void changePreviewer(Component panelPreview) {
        Fragment fragment = new Fragment("panelPreview", "previewFragment", (MarkupContainer)this.container);
        fragment.add(new Component[]{panelPreview});
        this.container.addOrReplace(new Component[]{fragment});
        this.uploadForm.addOrReplace(new Component[]{this.container});
    }

    @Override
    public BinaryFieldPanel clone() {
        return (BinaryFieldPanel)super.clone();
    }

    @Override
    public FieldPanel<String> setNewModel(IModel<String> model) {
        this.field.setModel(model);
        try {
            Component panelPreview = this.previewUtil.getPreviewer(this.mimeType, (String)model.getObject());
            if (panelPreview != null) {
                this.changePreviewer(panelPreview);
            }
        }
        catch (Exception e) {
            LOG.error("While loading saved file", (Throwable)e);
        }
        this.downloadLink.setEnabled(StringUtils.isNotBlank((CharSequence)((CharSequence)model.getObject())));
        this.uploadForm.addOrReplace(new Component[]{this.downloadLink});
        return this;
    }
}

