/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.syncope.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.springframework.util.StringUtils;

public class DateFieldPanel
extends FieldPanel<Date> {
    private static final long serialVersionUID = -428975732068281726L;
    protected final String name;
    protected final String datePattern;

    protected DateFieldPanel(String id, String name, IModel<Date> model, String datePattern) {
        super(id, model);
        this.name = name;
        this.datePattern = datePattern;
    }

    @Override
    public FieldPanel<Date> setNewModel(final List<Serializable> list) {
        final SimpleDateFormat formatter = this.datePattern == null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault()) : new SimpleDateFormat(this.datePattern, Locale.getDefault());
        this.setNewModel(new Model<Date>(){
            private static final long serialVersionUID = 527651414610325237L;

            public Date getObject() {
                Date date = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.get(0)).toString())) {
                    try {
                        date = formatter.parse(((Serializable)list.get(0)).toString());
                    }
                    catch (ParseException e) {
                        AbstractFieldPanel.LOG.error("invalid parse exception", (Throwable)e);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                list.clear();
                if (object != null) {
                    list.add(formatter.format(object));
                }
            }
        });
        return this;
    }

    @Override
    public FieldPanel<Date> setNewModel(final ListItem item) {
        final SimpleDateFormat formatter = this.datePattern == null ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.getDefault()) : new SimpleDateFormat(this.datePattern, Locale.getDefault());
        Model<Date> model = new Model<Date>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public Date getObject() {
                Date date = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        try {
                            date = formatter.parse(obj.toString());
                        }
                        catch (ParseException e) {
                            AbstractFieldPanel.LOG.error("While parsing date", (Throwable)e);
                        }
                    } else {
                        date = obj instanceof Date ? (Date)obj : new Date((Long)obj);
                    }
                }
                return date;
            }

            public void setObject(Date object) {
                item.setModelObject(object != null ? formatter.format(object) : null);
            }
        };
        this.field.setModel((IModel)model);
        return this;
    }
}

