/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.syncope.console.wicket.markup.html.form.DateFieldPanel;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.yui.calendar.DateTimeField;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;

public class DateTimeFieldPanel
extends DateFieldPanel {
    private static final long serialVersionUID = -428975732068281726L;
    private Form<?> form = null;

    public DateTimeFieldPanel(String id, String name, IModel<Date> model, String datePattern) {
        super(id, name, model, datePattern);
        this.field = new DateTimeField("field", model);
        final Calendar cal = Calendar.getInstance();
        this.field.get("hours").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Integer hours = ((DateTimeField)DateTimeFieldPanel.this.field).getHours();
                if (hours != null) {
                    cal.set(hours > 12 ? 11 : 10, hours);
                    DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
                }
            }
        }});
        this.field.get("minutes").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Integer minutes = ((DateTimeField)DateTimeFieldPanel.this.field).getMinutes();
                if (minutes != null) {
                    cal.set(12, minutes);
                    DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
                }
            }
        }});
        this.field.get("date").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                Date date = ((DateTimeField)DateTimeFieldPanel.this.field).getDate();
                if (date == null) {
                    DateTimeFieldPanel.this.field.setModelObject(null);
                } else {
                    cal.setTime(date);
                    cal.set(9, "PM".equals("" + ((DateTimeField)DateTimeFieldPanel.this.field).getAmOrPm()) ? 1 : 0);
                    DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
                }
            }
        }});
        this.field.get("amOrPmChoice").add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                cal.set(9, "PM".equals("" + ((DateTimeField)DateTimeFieldPanel.this.field).getAmOrPm()) ? 1 : 0);
                DateTimeFieldPanel.this.field.setModelObject((Object)cal.getTime());
            }
        }});
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name))).setOutputMarkupId(true)});
    }

    public FieldPanel<Date> setFormValidator(Form<?> form) {
        if (this.field == null) {
            LOG.error("Error setting form validator");
        } else {
            form.add((IFormValidator)new DateTimeFormValidator((DateTimeField)this.field));
            this.form = form;
        }
        return this;
    }

    @Override
    public FieldPanel<Date> setStyleSheet(String classes) {
        this.field.get("date").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)((classes == null ? "" : classes) + " date_size")))});
        this.field.get("hours").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes == null ? "" : classes)))});
        this.field.get("minutes").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes == null ? "" : classes)))});
        this.field.get("amOrPmChoice").add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)(classes == null ? "" : classes)))});
        return this;
    }

    @Override
    public FieldPanel<Date> clone() {
        DateTimeFieldPanel panel = new DateTimeFieldPanel(this.getId(), this.name, (IModel<Date>)new Model(null), this.datePattern);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        if (this.form != null && this.isRequired()) {
            panel.setFormValidator(this.form);
        }
        return panel;
    }

    private class DateTimeFormValidator
    extends AbstractFormValidator {
        private static final long serialVersionUID = 6842264694946633582L;
        private FormComponent<?>[] dateTimeComponents;

        public DateTimeFormValidator(DateTimeField dateTimeComponent) {
            if (dateTimeComponent == null) {
                throw new IllegalArgumentException("argument dateTimeComponent cannot be null");
            }
            this.dateTimeComponents = new FormComponent[]{dateTimeComponent};
        }

        public FormComponent<?>[] getDependentFormComponents() {
            return this.dateTimeComponents;
        }

        public void validate(Form<?> form) {
            DateTimeField dateTimeField = (DateTimeField)this.dateTimeComponents[0];
            if (dateTimeField.getDate() == null || dateTimeField.getHours() == null || dateTimeField.getMinutes() == null) {
                ValidationError ve = new ValidationError();
                ve.setVariables(this.variablesMap());
                ve.addKey(this.resourceKey());
                this.dateTimeComponents[0].error((IValidationError)ve);
            }
        }
    }
}

