/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.syncope.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.springframework.util.StringUtils;

public class SpinnerFieldPanel<T extends Number>
extends FieldPanel<T> {
    private static final long serialVersionUID = 6413819574530703577L;
    private final String name;
    private final Class<T> reference;
    private final IModel<T> model;
    private final T min;
    private final T max;

    public SpinnerFieldPanel(String id, String name, Class<T> reference, IModel<T> model, T min, T max) {
        super(id, model);
        this.name = name;
        this.reference = reference;
        this.model = model;
        this.min = min;
        this.max = max;
        String uuid = UUID.randomUUID().toString();
        this.field = new TextField("spinnerField", model, reference);
        this.field.setMarkupId(uuid);
        this.add(new Component[]{this.field.setLabel((IModel)new Model((Serializable)((Object)name)))});
        if (!this.isReadOnly()) {
            this.field.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
        StringBuilder statements = new StringBuilder();
        statements.append("jQuery(function() {").append("var spinner = $('#").append(uuid).append("').spinner();").append("$('#").append(uuid).append("').spinner(").append("'option', 'stop', function(event, ui) { $(this).change(); });");
        if (this.min != null) {
            statements.append("$('#").append(uuid).append("').spinner(").append("'option', 'min', ").append(this.min).append(");");
        }
        if (this.max != null) {
            statements.append("$('#").append(uuid).append("').spinner(").append("'option', 'max', ").append(this.max).append(");");
        }
        statements.append("});");
        Label spinnerFieldJS = new Label("spinnerFieldJS", statements.toString());
        spinnerFieldJS.setEscapeModelStrings(false);
        this.add(new Component[]{spinnerFieldJS});
    }

    @Override
    public SpinnerFieldPanel<T> setNewModel(final List<Serializable> list) {
        this.setNewModel(new Model<T>(){
            private static final long serialVersionUID = 527651414610325237L;

            public T getObject() {
                Number value = null;
                if (list != null && !list.isEmpty() && StringUtils.hasText((String)((Serializable)list.get(0)).toString())) {
                    value = SpinnerFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(NumberUtils.toInt((String)((Serializable)list.get(0)).toString()))) : (Number)(SpinnerFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(NumberUtils.toLong((String)((Serializable)list.get(0)).toString()))) : (Number)(SpinnerFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(NumberUtils.toShort((String)((Serializable)list.get(0)).toString()))) : (Number)(SpinnerFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Float.valueOf(NumberUtils.toFloat((String)((Serializable)list.get(0)).toString())))) : (Number)(SpinnerFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(NumberUtils.toByte((String)((Serializable)list.get(0)).toString()))) : (Number)((Number)SpinnerFieldPanel.this.reference.cast(NumberUtils.toDouble((String)((Serializable)list.get(0)).toString())))))));
                }
                return value;
            }

            public void setObject(T object) {
                list.clear();
                if (object != null) {
                    list.add(object.toString());
                }
            }
        });
        return this;
    }

    @Override
    public SpinnerFieldPanel<T> setNewModel(final ListItem item) {
        this.field.setModel((IModel)new Model<T>(){
            private static final long serialVersionUID = 6799404673615637845L;

            public T getObject() {
                Number number = null;
                Object obj = item.getModelObject();
                if (obj != null && !obj.toString().isEmpty()) {
                    if (obj instanceof String) {
                        number = SpinnerFieldPanel.this.reference.equals(Integer.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Integer.valueOf((String)obj))) : (Number)(SpinnerFieldPanel.this.reference.equals(Long.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Long.valueOf((String)obj))) : (Number)(SpinnerFieldPanel.this.reference.equals(Short.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Short.valueOf((String)obj))) : (Number)(SpinnerFieldPanel.this.reference.equals(Float.class) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Float.valueOf((String)obj))) : (Number)(SpinnerFieldPanel.this.reference.equals(Byte.TYPE) ? (Number)((Number)SpinnerFieldPanel.this.reference.cast(Byte.valueOf((String)obj))) : (Number)((Number)SpinnerFieldPanel.this.reference.cast(Double.valueOf((String)obj)))))));
                    } else if (obj instanceof Number) {
                        number = (Number)SpinnerFieldPanel.this.reference.cast(obj);
                    }
                }
                return number;
            }

            public void setObject(T object) {
                item.setModelObject((Object)(object == null ? null : object.toString()));
            }
        });
        return this;
    }

    @Override
    public SpinnerFieldPanel<T> clone() {
        SpinnerFieldPanel<T> panel = new SpinnerFieldPanel<T>(this.getId(), this.name, this.reference, this.model, this.min, this.max);
        panel.setRequired(this.isRequired());
        panel.setReadOnly(this.isReadOnly());
        panel.setTitle(this.title);
        if (this.isRequiredLabelAdded) {
            panel.addRequiredLabel();
        }
        return panel;
    }
}

