/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.console;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.syncope.console.SyncopeApplication;
import org.apache.syncope.console.SyncopeRequestCycleListener;
import org.apache.syncope.console.SyncopeSession;
import org.apache.syncope.console.commons.XMLRolesReader;
import org.apache.syncope.console.pages.Configuration;
import org.apache.syncope.console.pages.Login;
import org.apache.syncope.console.pages.Logout;
import org.apache.syncope.console.pages.Reports;
import org.apache.syncope.console.pages.Resources;
import org.apache.syncope.console.pages.Roles;
import org.apache.syncope.console.pages.Schema;
import org.apache.syncope.console.pages.Tasks;
import org.apache.syncope.console.pages.Todo;
import org.apache.syncope.console.pages.Users;
import org.apache.syncope.console.pages.WelcomePage;
import org.apache.syncope.console.rest.UserSelfRestClient;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.RoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SyncopeApplication
extends WebApplication
implements IUnauthorizedComponentInstantiationListener,
IRoleCheckingStrategy,
Serializable {
    private static final long serialVersionUID = -2920378752291913495L;
    public static final String IMG_PREFIX = "/img/menu/";
    public static final String IMG_NOTSEL = "notsel/";
    private static final String ACTIVITI_MODELER_CONTEXT = "activiti-modeler";
    private static final int EDIT_PROFILE_WIN_HEIGHT = 550;
    private static final int EDIT_PROFILE_WIN_WIDTH = 800;

    protected void init() {
        super.init();
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this));
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new RoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.getSecuritySettings().setUnauthorizedComponentInstantiationListener((IUnauthorizedComponentInstantiationListener)this);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        this.getRequestCycleListeners().add((Object)new SyncopeRequestCycleListener());
        String activitiModelerDirectory = (String)WebApplicationContextUtils.getWebApplicationContext((ServletContext)WebApplication.get().getServletContext()).getBean("activitiModelerDirectory", String.class);
        this.mountResource("/activiti-modeler", (ResourceReference)new /* Unavailable Anonymous Inner Class!! */);
        this.mountResource("/workflowDefGET", (ResourceReference)new /* Unavailable Anonymous Inner Class!! */);
        this.mountResource("/workflowDefPUT", (ResourceReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setupNavigationPanel(WebPage page, XMLRolesReader xmlRolesReader, boolean notsel) {
        ModalWindow infoModal = new ModalWindow("infoModal");
        page.add(new Component[]{infoModal});
        infoModal.setInitialWidth(350);
        infoModal.setInitialHeight(300);
        infoModal.setCssClassName("w_silver");
        infoModal.setCookieName("infoModal");
        infoModal.setPageCreator((ModalWindow.PageCreator)new /* Unavailable Anonymous Inner Class!! */);
        5 infoLink = new /* Unavailable Anonymous Inner Class!! */;
        page.add(new Component[]{infoLink});
        BookmarkablePageLink schemaLink = new BookmarkablePageLink("schema", Schema.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)schemaLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Schema", "list"));
        page.add(new Component[]{schemaLink});
        schemaLink.add(new Component[]{new Image("schemaIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "schema" + ".png"))});
        BookmarkablePageLink usersLink = new BookmarkablePageLink("users", Users.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)usersLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Users", "list"));
        page.add(new Component[]{usersLink});
        usersLink.add(new Component[]{new Image("usersIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "users" + ".png"))});
        BookmarkablePageLink rolesLink = new BookmarkablePageLink("roles", Roles.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)rolesLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Roles", "list"));
        page.add(new Component[]{rolesLink});
        rolesLink.add(new Component[]{new Image("rolesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "roles" + ".png"))});
        BookmarkablePageLink resourcesLink = new BookmarkablePageLink("resources", Resources.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)resourcesLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Resources", "list"));
        page.add(new Component[]{resourcesLink});
        resourcesLink.add(new Component[]{new Image("resourcesIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "resources" + ".png"))});
        BookmarkablePageLink todoLink = new BookmarkablePageLink("todo", Todo.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)todoLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Approval", "list"));
        page.add(new Component[]{todoLink});
        todoLink.add(new Component[]{new Image("todoIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "todo" + ".png"))});
        BookmarkablePageLink reportLink = new BookmarkablePageLink("reports", Reports.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)reportLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Reports", "list"));
        page.add(new Component[]{reportLink});
        reportLink.add(new Component[]{new Image("reportsIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "reports" + ".png"))});
        BookmarkablePageLink configurationLink = new BookmarkablePageLink("configuration", Configuration.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)configurationLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Configuration", "list"));
        page.add(new Component[]{configurationLink});
        configurationLink.add(new Component[]{new Image("configurationIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "configuration" + ".png"))});
        BookmarkablePageLink taskLink = new BookmarkablePageLink("tasks", Tasks.class);
        MetaDataRoleAuthorizationStrategy.authorize((Component)taskLink, (Action)WebPage.ENABLE, (String)xmlRolesReader.getEntitlement("Tasks", "list"));
        page.add(new Component[]{taskLink});
        taskLink.add(new Component[]{new Image("tasksIcon", (IResource)new ContextRelativeResource(IMG_PREFIX + (notsel ? IMG_NOTSEL : "") + "tasks" + ".png"))});
        page.add(new Component[]{new BookmarkablePageLink("logout", Logout.class)});
    }

    public void setupEditProfileModal(WebPage page, UserSelfRestClient userSelfRestClient) {
        ModalWindow editProfileModalWin = new ModalWindow("editProfileModal");
        editProfileModalWin.setCssClassName("w_silver");
        editProfileModalWin.setInitialHeight(550);
        editProfileModalWin.setInitialWidth(800);
        editProfileModalWin.setCookieName("edit-profile-modal");
        page.add(new Component[]{editProfileModalWin});
        6 editProfileLink = new /* Unavailable Anonymous Inner Class!! */;
        editProfileLink.add(new Component[]{new Label("username", SyncopeSession.get().getUsername())});
        if ("admin".equals(SyncopeSession.get().getUsername())) {
            editProfileLink.setEnabled(false);
        }
        page.add(new Component[]{editProfileLink});
    }

    public Session newSession(Request request, Response response) {
        return new SyncopeSession(request);
    }

    public Class<? extends Page> getHomePage() {
        return SyncopeSession.get().isAuthenticated() ? WelcomePage.class : Login.class;
    }

    public void onUnauthorizedInstantiation(Component component) {
        SyncopeSession.get().invalidate();
        if (component instanceof Page) {
            throw new UnauthorizedInstantiationException(component.getClass());
        }
        throw new RestartResponseAtInterceptPageException(Login.class);
    }

    public boolean hasAnyRole(org.apache.wicket.authroles.authorization.strategies.role.Roles roles) {
        return SyncopeSession.get().hasAnyRole(roles);
    }
}

